/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ValueInfo;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.DefaultProcessClassLoaderFactory;
import org.jbpm.instantiation.ProcessClassLoaderFactory;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ObjectFactory defaultObjectFactory;
    static Map instances;
    static ThreadLocal jbpmConfigurationsStacks;
    private ObjectFactory objectFactory;
    private ThreadLocal jbpmContextStacks = new ThreadLocal();
    private JobExecutor jobExecutor;
    private static Log log;

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance = null;
        Map map = instances;
        synchronized (map) {
            if (resource == null) {
                resource = "jbpm.cfg.xml";
            }
            if ((instance = (JbpmConfiguration)instances.get(resource)) == null) {
                if (defaultObjectFactory != null) {
                    log.debug((Object)("creating jbpm configuration from given default object factory '" + defaultObjectFactory + "'"));
                    instance = new JbpmConfiguration(defaultObjectFactory);
                } else {
                    try {
                        log.info((Object)("using jbpm configuration resource '" + resource + "'"));
                        InputStream jbpmCfgXmlStream = ClassLoaderUtil.getJbpmConfigurationStream(resource);
                        if (jbpmCfgXmlStream == null && !"jbpm.cfg.xml".equals(resource)) {
                            log.warn((Object)("jbpm configuration resource '" + resource + "' is not available"));
                        }
                        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(jbpmCfgXmlStream);
                        instance = JbpmConfiguration.createJbpmConfiguration(objectFactory);
                    }
                    catch (RuntimeException e) {
                        throw new JbpmException("couldn't parse jbpm configuration from resource '" + resource + "'", e);
                    }
                }
                instances.put(resource, instance);
            }
        }
        return instance;
    }

    public static boolean hasInstance(String resource) {
        boolean hasInstance = false;
        if (resource == null) {
            resource = "jbpm.cfg.xml";
        }
        if (instances != null && instances.containsKey(resource)) {
            hasInstance = true;
        }
        return hasInstance;
    }

    protected static ObjectFactory parseObjectFactory(InputStream inputStream) {
        log.debug((Object)"loading defaults in jbpm configuration");
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ObjectFactoryImpl objectFactoryImpl = new ObjectFactoryImpl();
        objectFactoryParser.parseElementsFromResource("org/jbpm/default.jbpm.cfg.xml", objectFactoryImpl);
        if (inputStream != null) {
            log.debug((Object)"loading specific configuration...");
            objectFactoryParser.parseElementsStream(inputStream, objectFactoryImpl);
        }
        return objectFactoryImpl;
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        log.debug((Object)"creating jbpm configuration from xml string");
        ByteArrayInputStream inputStream = null;
        if (xml != null) {
            inputStream = new ByteArrayInputStream(xml.getBytes());
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    protected static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration(objectFactory);
        if (objectFactory instanceof ObjectFactoryImpl) {
            ObjectFactoryImpl objectFactoryImpl = (ObjectFactoryImpl)objectFactory;
            ValueInfo jbpmConfigurationInfo = new ValueInfo("jbpmConfiguration", jbpmConfiguration);
            objectFactoryImpl.addObjectInfo(jbpmConfigurationInfo);
            if (JbpmConfiguration.getHideStaleObjectExceptions(objectFactory)) {
                StaleObjectLogConfigurer.hideStaleObjectExceptions();
            }
        }
        return jbpmConfiguration;
    }

    private static boolean getHideStaleObjectExceptions(ObjectFactory objectFactory) {
        if (!objectFactory.hasObject("jbpm.hide.stale.object.exceptions")) {
            return true;
        }
        Object object = objectFactory.createObject("jbpm.hide.stale.object.exceptions");
        return object instanceof Boolean ? (Boolean)object : true;
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        log.debug((Object)"creating jbpm configuration from input stream");
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        InputStream inputStream = null;
        log.debug((Object)("creating jbpm configuration from resource '" + resource + "'"));
        if (resource != null) {
            inputStream = ClassLoaderUtil.getJbpmConfigurationStream(resource);
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        jbpmContext.jbpmConfiguration = this;
        this.jbpmContextCreated(jbpmContext);
        return jbpmContext;
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        ServiceFactory serviceFactory = null;
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
        }
        finally {
            jbpmContext.close();
        }
        return serviceFactory;
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        ProcessClassLoaderFactory factory = null;
        factory = Configs.hasObject("jbpm.processClassLoader") ? (ProcessClassLoaderFactory)Configs.getObject("jbpm.processClassLoader") : new DefaultProcessClassLoaderFactory();
        return factory.getProcessClassLoader(processDefinition);
    }

    public void cleanSchema() {
        this.cleanSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.cleanSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.createSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(String jbpmContextName) {
        log.warn((Object)("Dropping schema: " + jbpmContextName));
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.dropSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public void close() {
        this.close("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Map serviceFactories;
            Map map = instances;
            synchronized (map) {
                for (String resource : instances.keySet()) {
                    if (this != instances.get(resource)) continue;
                    instances.remove(resource);
                    break;
                }
            }
            if (this.jobExecutor != null) {
                this.jobExecutor.stop();
            }
            if ((serviceFactories = jbpmContext.getServices().getServiceFactories()) != null) {
                for (ServiceFactory serviceFactory : serviceFactories.values()) {
                    serviceFactory.close();
                }
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    static JbpmConfiguration getCurrentJbpmConfiguration() {
        JbpmConfiguration currentJbpmConfiguration = null;
        Stack stack = JbpmConfiguration.getJbpmConfigurationStack();
        if (!stack.isEmpty()) {
            currentJbpmConfiguration = (JbpmConfiguration)stack.peek();
        }
        return currentJbpmConfiguration;
    }

    static synchronized Stack getJbpmConfigurationStack() {
        Stack stack = (Stack)jbpmConfigurationsStacks.get();
        if (stack == null) {
            stack = new Stack();
            jbpmConfigurationsStacks.set(stack);
        }
        return stack;
    }

    synchronized void pushJbpmConfiguration() {
        JbpmConfiguration.getJbpmConfigurationStack().push(this);
    }

    synchronized void popJbpmConfiguration() {
        JbpmConfiguration.getJbpmConfigurationStack().remove(this);
    }

    public JbpmContext getCurrentJbpmContext() {
        JbpmContext currentJbpmContext = null;
        Stack stack = this.getJbpmContextStack();
        if (!stack.isEmpty()) {
            currentJbpmContext = (JbpmContext)stack.peek();
        }
        return currentJbpmContext;
    }

    Stack getJbpmContextStack() {
        Stack stack = (Stack)this.jbpmContextStacks.get();
        if (stack == null) {
            stack = new Stack();
            this.jbpmContextStacks.set(stack);
        }
        return stack;
    }

    void pushJbpmContext(JbpmContext jbpmContext) {
        this.getJbpmContextStack().push(jbpmContext);
    }

    void popJbpmContext(JbpmContext jbpmContext) {
        Stack stack = this.getJbpmContextStack();
        if (stack.isEmpty()) {
            throw new JbpmException("closed JbpmContext more then once... check your try-finally's around JbpmContexts blocks");
        }
        JbpmContext popped = (JbpmContext)stack.pop();
        if (jbpmContext != popped) {
            throw new JbpmException("closed JbpmContext in different order then they were created... check your try-finally's around JbpmContexts blocks");
        }
    }

    void jbpmContextCreated(JbpmContext jbpmContext) {
        this.pushJbpmConfiguration();
        this.pushJbpmContext(jbpmContext);
    }

    void jbpmContextClosed(JbpmContext jbpmContext) {
        this.popJbpmConfiguration();
        this.popJbpmContext(jbpmContext);
    }

    public void startJobExecutor() {
        this.getJobExecutor().start();
    }

    public synchronized JobExecutor getJobExecutor() {
        if (this.jobExecutor == null) {
            try {
                this.jobExecutor = (JobExecutor)this.objectFactory.createObject("jbpm.job.executor");
            }
            catch (ClassCastException e) {
                throw new JbpmException("jbpm configuration object under key 'jbpm.job.executor' is not a " + JobExecutor.class.getName(), e);
            }
        }
        return this.jobExecutor;
    }

    static {
        instances = new HashMap();
        jbpmConfigurationsStacks = new ThreadLocal();
        log = LogFactory.getLog(JbpmConfiguration.class);
    }

    public static abstract class Configs {
        public static ObjectFactory getObjectFactory() {
            ObjectFactory objectFactory = null;
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            objectFactory = jbpmContext != null ? jbpmContext.objectFactory : JbpmConfiguration.getInstance().objectFactory;
            return objectFactory;
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            defaultObjectFactory = objectFactory;
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static synchronized Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static int getInt(String name) {
            return (Integer)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }
}

