/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;

public class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static Class loadClass(String className) {
        try {
            return ClassLoaderUtil.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found: " + className, e);
        }
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        return Class.forName(className, false, ClassLoaderUtil.getClassLoader());
    }

    public static Class classForName(String className, boolean useConfiguredLoader) throws ClassNotFoundException {
        if (useConfiguredLoader) {
            return ClassLoaderUtil.classForName(className);
        }
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return Class.forName(className, false, ClassLoaderUtil.class.getClassLoader());
        }
    }

    public static ClassLoader getClassLoader() {
        ObjectFactory objectFactory = JbpmConfiguration.Configs.getObjectFactory();
        if (objectFactory.hasObject("jbpm.class.loader")) {
            String classLoader = (String)objectFactory.createObject("jbpm.class.loader");
            if ("jbpm".equals(classLoader)) {
                return ClassLoaderUtil.class.getClassLoader();
            }
            if (classLoader.equals("context")) {
                return Thread.currentThread().getContextClassLoader();
            }
            return (ClassLoader)objectFactory.createObject(classLoader);
        }
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static InputStream getStream(String resource) {
        return ClassLoaderUtil.getClassLoader().getResourceAsStream(resource);
    }

    public static InputStream getStream(String resource, boolean useConfiguredLoader) {
        if (useConfiguredLoader) {
            return ClassLoaderUtil.getStream(resource);
        }
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassLoaderUtil.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getProperties(String resource) {
        Properties properties2;
        InputStream inStream = ClassLoaderUtil.getStream(resource);
        if (inStream == null) {
            throw new JbpmException("resource not found: " + resource);
        }
        try {
            Properties properties = new Properties();
            properties.load(inStream);
            properties2 = properties;
        }
        catch (IOException e) {
            try {
                throw new JbpmException("could not load properties from resource: " + resource, e);
            }
            catch (Throwable throwable) {
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LogFactory.getLog((Class)ClassLoaderUtil.class).warn((Object)("failed to close resource: " + resource), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            inStream.close();
            return properties2;
        }
        catch (IOException e) {
            LogFactory.getLog((Class)ClassLoaderUtil.class).warn((Object)("failed to close resource: " + resource), (Throwable)e);
        }
        return properties2;
    }
}

