/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.UserCodeInterceptor;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.security.SecurityHelper;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.TaskInstanceFactory;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.log.TaskCreateLog;
import org.jbpm.util.Clock;

public class TaskMgmtInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    private TaskMgmtDefinition taskMgmtDefinition;
    private Map swimlaneInstances;
    private Set taskInstances;
    private Collection taskInstanceVariableUpdates;

    public TaskMgmtInstance() {
    }

    public TaskMgmtInstance(TaskMgmtDefinition taskMgmtDefinition) {
        this.taskMgmtDefinition = taskMgmtDefinition;
    }

    public TaskInstance createTaskInstance() {
        return this.createTaskInstance(null, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Task task) {
        return this.createTaskInstance(task, (ExecutionContext)null);
    }

    public TaskInstance createTaskInstance(Token token) {
        return this.createTaskInstance(null, new ExecutionContext(token));
    }

    public TaskInstance createTaskInstance(Task task, Token token) {
        ExecutionContext executionContext = new ExecutionContext(token);
        executionContext.setTask(task);
        return this.createTaskInstance(task, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInstance createTaskInstance(Task task, ExecutionContext executionContext) {
        TaskInstance taskInstance = this.instantiateNewTaskInstance(executionContext);
        Services.assignId(taskInstance);
        if (task != null) {
            taskInstance.setTask(task);
        }
        this.addTaskInstance(taskInstance);
        if (executionContext != null) {
            String dueDateString;
            Token token = executionContext.getToken();
            taskInstance.setToken(token);
            taskInstance.setProcessInstance(token.getProcessInstance());
            taskInstance.initializeVariables();
            if (task != null && (dueDateString = task.getDueDate()) != null) {
                Date dueDate;
                if (dueDateString.startsWith("#{") || dueDateString.startsWith("${")) {
                    Date baseDate;
                    int braceIndex = dueDateString.indexOf(125);
                    if (braceIndex == -1) {
                        throw new JbpmException("invalid due date, closing brace missing: " + dueDateString);
                    }
                    String baseDateExpression = dueDateString.substring(0, braceIndex + 1);
                    Object result = JbpmExpressionEvaluator.evaluate(baseDateExpression, executionContext);
                    if (result instanceof Date) {
                        baseDate = (Date)result;
                    } else if (result instanceof Calendar) {
                        baseDate = ((Calendar)result).getTime();
                    } else {
                        throw new JbpmException(baseDateExpression + " returned " + result + " instead of date or calendar");
                    }
                    String durationString = dueDateString.substring(braceIndex + 1).trim();
                    if (durationString.length() > 0) {
                        char durationSeparator = durationString.charAt(0);
                        if (durationSeparator != '+' && durationSeparator != '-') {
                            throw new JbpmException("invalid due date, '+' or '-' missing after expression: " + dueDateString);
                        }
                        dueDate = new BusinessCalendar().add(baseDate, new Duration(durationString));
                    } else {
                        dueDate = baseDate;
                    }
                } else {
                    dueDate = new BusinessCalendar().add(Clock.getCurrentTime(), new Duration(dueDateString));
                }
                taskInstance.setDueDate(dueDate);
            }
            try {
                Object result;
                String description;
                executionContext.setTask(task);
                executionContext.setTaskInstance(taskInstance);
                executionContext.setEventSource(task);
                if (task != null && (description = task.getDescription()) != null && description.indexOf("#{") != -1 && (result = JbpmExpressionEvaluator.evaluate(description, executionContext)) != null) {
                    taskInstance.setDescription(result.toString());
                }
                taskInstance.create(executionContext);
                if (task != null) {
                    taskInstance.assign(executionContext);
                }
            }
            finally {
                executionContext.setTask(null);
                executionContext.setTaskInstance(null);
                executionContext.setEventSource(null);
            }
            token.addLog(new TaskCreateLog(taskInstance, taskInstance.getActorId()));
        } else {
            taskInstance.create();
        }
        return taskInstance;
    }

    public SwimlaneInstance getInitializedSwimlaneInstance(ExecutionContext executionContext, Swimlane swimlane) {
        SwimlaneInstance swimlaneInstance;
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        if ((swimlaneInstance = (SwimlaneInstance)this.swimlaneInstances.get(swimlane.getName())) == null) {
            swimlaneInstance = new SwimlaneInstance(swimlane);
            this.addSwimlaneInstance(swimlaneInstance);
            this.performAssignment(swimlane.getAssignmentDelegation(), swimlane.getActorIdExpression(), swimlane.getPooledActorsExpression(), swimlaneInstance, executionContext);
        }
        return swimlaneInstance;
    }

    public void performAssignment(Delegation assignmentDelegation, String actorIdExpression, String pooledActorsExpression, Assignable assignable, ExecutionContext executionContext) {
        if (assignmentDelegation != null) {
            this.performAssignmentDelegation(assignmentDelegation, assignable, executionContext);
        } else {
            if (actorIdExpression != null) {
                this.performAssignmentActorIdExpr(actorIdExpression, assignable, executionContext);
            }
            if (pooledActorsExpression != null) {
                this.performAssignmentPooledActorsExpr(pooledActorsExpression, assignable, executionContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAssignmentDelegation(Delegation assignmentDelegation, Assignable assignable, ExecutionContext executionContext) {
        block7: {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader processClassLoader = JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition());
                Thread.currentThread().setContextClassLoader(processClassLoader);
                AssignmentHandler assignmentHandler = (AssignmentHandler)assignmentDelegation.instantiate();
                UserCodeInterceptor userCodeInterceptor = UserCodeInterceptorConfig.getUserCodeInterceptor();
                try {
                    if (userCodeInterceptor != null) {
                        userCodeInterceptor.executeAssignment(assignmentHandler, assignable, executionContext);
                        break block7;
                    }
                    assignmentHandler.assign(assignable, executionContext);
                }
                catch (Exception e) {
                    GraphElement eventSource = executionContext.getEventSource();
                    if (eventSource == null) {
                        throw e instanceof JbpmException ? (JbpmException)e : new DelegationException("event source is null", e);
                    }
                    eventSource.raiseException(e, executionContext);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    private void performAssignmentActorIdExpr(String actorIdExpression, Assignable assignable, ExecutionContext executionContext) {
        String actorId = (String)JbpmExpressionEvaluator.evaluate(actorIdExpression, executionContext, String.class);
        if (actorId == null) {
            throw new JbpmException(actorIdExpression + " returned null");
        }
        assignable.setActorId(actorId);
    }

    private void performAssignmentPooledActorsExpr(String pooledActorsExpression, Assignable assignable, ExecutionContext executionContext) {
        String[] pooledActors;
        Object result = JbpmExpressionEvaluator.evaluate(pooledActorsExpression, executionContext);
        if (result instanceof String) {
            String csv = (String)result;
            pooledActors = csv.split(",");
            for (int i = 0; i < pooledActors.length; ++i) {
                pooledActors[i] = pooledActors[i].trim();
            }
        } else if (result instanceof String[]) {
            pooledActors = (String[])result;
        } else if (result instanceof Collection) {
            Collection collection = (Collection)result;
            pooledActors = collection.toArray(new String[collection.size()]);
        } else {
            throw new JbpmException(pooledActorsExpression + " returned " + result + " instead of comma-separated string, collection or string array");
        }
        assignable.setPooledActors(pooledActors);
    }

    public TaskInstance createStartTaskInstance() {
        TaskInstance taskInstance = null;
        Task startTask = this.taskMgmtDefinition.getStartTask();
        if (startTask != null) {
            Token rootToken = this.processInstance.getRootToken();
            ExecutionContext executionContext = new ExecutionContext(rootToken);
            taskInstance = this.createTaskInstance(startTask, executionContext);
            taskInstance.setActorId(SecurityHelper.getAuthenticatedActorId());
        }
        return taskInstance;
    }

    private TaskInstance instantiateNewTaskInstance(ExecutionContext executionContext) {
        if (JbpmConfiguration.Configs.hasObject("jbpm.task.instance.factory")) {
            TaskInstanceFactory factory = (TaskInstanceFactory)JbpmConfiguration.Configs.getObject("jbpm.task.instance.factory");
            return factory.createTaskInstance(executionContext);
        }
        return new TaskInstance();
    }

    public boolean hasBlockingTaskInstances(Token token) {
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (taskInstance.hasEnded() || !taskInstance.isBlocking() || token == null || !token.equals(taskInstance.getToken())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasUnfinishedTasks(Token token) {
        return this.getUnfinishedTasks(token).size() > 0;
    }

    public Collection getUnfinishedTasks(Token token) {
        ArrayList<TaskInstance> unfinishedTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance task = (TaskInstance)i.next();
                if (task.hasEnded() || token == null || !token.equals(task.getToken())) continue;
                unfinishedTasks.add(task);
            }
        }
        return unfinishedTasks;
    }

    public boolean hasSignallingTasks(ExecutionContext executionContext) {
        return this.getSignallingTasks(executionContext).size() > 0;
    }

    public Collection getSignallingTasks(ExecutionContext executionContext) {
        ArrayList<TaskInstance> signallingTasks = new ArrayList<TaskInstance>();
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (!taskInstance.isSignalling() || !executionContext.getToken().equals(taskInstance.getToken())) continue;
                signallingTasks.add(taskInstance);
            }
        }
        return signallingTasks;
    }

    public Collection getTaskInstances() {
        return this.taskInstances;
    }

    public void addTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances == null) {
            this.taskInstances = new HashSet();
        }
        this.taskInstances.add(taskInstance);
        taskInstance.setTaskMgmtInstance(this);
    }

    public void removeTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances != null) {
            this.taskInstances.remove(taskInstance);
        }
    }

    public Map getSwimlaneInstances() {
        return this.swimlaneInstances;
    }

    public void addSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        this.swimlaneInstances.put(swimlaneInstance.getName(), swimlaneInstance);
        swimlaneInstance.setTaskMgmtInstance(this);
    }

    public SwimlaneInstance getSwimlaneInstance(String swimlaneName) {
        return this.swimlaneInstances != null ? (SwimlaneInstance)this.swimlaneInstances.get(swimlaneName) : null;
    }

    public SwimlaneInstance createSwimlaneInstance(String swimlaneName) {
        Swimlane swimlane;
        Swimlane swimlane2 = swimlane = this.taskMgmtDefinition != null ? this.taskMgmtDefinition.getSwimlane(swimlaneName) : null;
        if (swimlane == null) {
            throw new JbpmException("swimlane does not exist: " + swimlaneName);
        }
        return this.createSwimlaneInstance(swimlane);
    }

    public SwimlaneInstance createSwimlaneInstance(Swimlane swimlane) {
        if (this.swimlaneInstances == null) {
            this.swimlaneInstances = new HashMap();
        }
        SwimlaneInstance swimlaneInstance = new SwimlaneInstance(swimlane);
        swimlaneInstance.setTaskMgmtInstance(this);
        this.swimlaneInstances.put(swimlaneInstance.getName(), swimlaneInstance);
        return swimlaneInstance;
    }

    public TaskMgmtDefinition getTaskMgmtDefinition() {
        return this.taskMgmtDefinition;
    }

    public void suspend(Token token) {
        if (token == null) {
            throw new JbpmException("can't suspend task instances for token null");
        }
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (!token.equals(taskInstance.getToken()) || !taskInstance.isOpen()) continue;
                taskInstance.suspend();
            }
        }
    }

    public void resume(Token token) {
        if (token == null) {
            throw new JbpmException("can't suspend task instances for token null");
        }
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (!token.equals(taskInstance.getToken()) || !taskInstance.isOpen()) continue;
                taskInstance.resume();
            }
        }
    }

    void notifyVariableUpdate(TaskInstance taskInstance) {
        if (this.taskInstanceVariableUpdates == null) {
            this.taskInstanceVariableUpdates = new HashSet();
        }
        this.taskInstanceVariableUpdates.add(taskInstance);
    }

    public Collection getTaskInstancesWithVariableUpdates() {
        return this.taskInstanceVariableUpdates;
    }

    public void endAll() {
        if (this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (taskInstance.hasEnded()) continue;
                taskInstance.end();
            }
        }
    }

    public void removeSignalling(Token token) {
        if (token != null && this.taskInstances != null) {
            Iterator i = this.taskInstances.iterator();
            while (i.hasNext()) {
                TaskInstance taskInstance = (TaskInstance)i.next();
                if (!token.equals(taskInstance.getToken())) continue;
                taskInstance.setSignalling(false);
            }
        }
    }
}

