/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.io.Serializable;
import java.util.Set;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class SwimlaneInstance
implements Serializable,
Assignable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String name;
    protected String actorId;
    protected Set pooledActors;
    protected Swimlane swimlane;
    protected TaskMgmtInstance taskMgmtInstance;

    public SwimlaneInstance() {
    }

    public SwimlaneInstance(Swimlane swimlane) {
        this.name = swimlane.getName();
        this.swimlane = swimlane;
    }

    public void setPooledActors(String[] actorIds) {
        this.pooledActors = PooledActor.createPool(actorIds, this, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SwimlaneInstance)) {
            return false;
        }
        SwimlaneInstance other = (SwimlaneInstance)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        return this.name.equals(other.getName()) && this.taskMgmtInstance.equals(other.getTaskMgmtInstance());
    }

    public int hashCode() {
        int result = 1429026763 + this.name.hashCode();
        result = 686197649 * result + this.taskMgmtInstance.hashCode();
        return result;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Swimlane getSwimlane() {
        return this.swimlane;
    }

    public String getActorId() {
        return this.actorId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return this.taskMgmtInstance;
    }

    public void setTaskMgmtInstance(TaskMgmtInstance taskMgmtInstance) {
        this.taskMgmtInstance = taskMgmtInstance;
    }

    public Set getPooledActors() {
        return this.pooledActors;
    }

    public void setPooledActors(Set pooledActors) {
        this.pooledActors = pooledActors;
    }
}

