/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.UserCodeInterceptor;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.taskmgmt.def.TaskControllerHandler;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    private Delegation taskControllerDelegation;
    private List variableAccesses;
    private static final Log log = LogFactory.getLog((Class)TaskController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeVariables(TaskInstance taskInstance) {
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = JbpmConfiguration.getProcessClassLoader(taskInstance.getTask().getProcessDefinition());
            Thread.currentThread().setContextClassLoader(classLoader);
            if (this.taskControllerDelegation != null) {
                TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
                ProcessInstance processInstance = taskInstance.getTaskMgmtInstance().getProcessInstance();
                ContextInstance contextInstance = processInstance != null ? processInstance.getContextInstance() : null;
                Token token = taskInstance.getToken();
                UserCodeInterceptor userCodeInterceptor = UserCodeInterceptorConfig.getUserCodeInterceptor();
                if (userCodeInterceptor != null) {
                    userCodeInterceptor.executeTaskControllerInitialization(taskControllerHandler, taskInstance, contextInstance, token);
                } else {
                    taskControllerHandler.initializeTaskVariables(taskInstance, contextInstance, token);
                }
            } else {
                Token token = taskInstance.getToken();
                ProcessInstance processInstance = token.getProcessInstance();
                ContextInstance contextInstance = processInstance.getContextInstance();
                if (this.variableAccesses != null) {
                    boolean debug = log.isDebugEnabled();
                    Iterator iter = this.variableAccesses.iterator();
                    while (iter.hasNext()) {
                        VariableAccess variableAccess = (VariableAccess)iter.next();
                        String mappedName = variableAccess.getMappedName();
                        if (variableAccess.isReadable()) {
                            String variableName = variableAccess.getVariableName();
                            Object value = contextInstance.getVariable(variableName, token);
                            if (debug) {
                                log.debug((Object)(taskInstance + " reads '" + variableName + "' into '" + mappedName + '\''));
                            }
                            taskInstance.setVariableLocally(mappedName, value);
                            continue;
                        }
                        if (debug) {
                            log.debug((Object)(token + " initializes '" + mappedName + " to null"));
                        }
                        taskInstance.setVariableLocally(mappedName, null);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitParameters(TaskInstance taskInstance) {
        if (this.taskControllerDelegation != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader processClassLoader = JbpmConfiguration.getProcessClassLoader(taskInstance.getTask().getProcessDefinition());
                Thread.currentThread().setContextClassLoader(processClassLoader);
                TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
                Token token = taskInstance.getToken();
                ContextInstance contextInstance = token != null ? token.getProcessInstance().getContextInstance() : null;
                UserCodeInterceptor userCodeInterceptor = UserCodeInterceptorConfig.getUserCodeInterceptor();
                if (userCodeInterceptor != null) {
                    userCodeInterceptor.executeTaskControllerSubmission(taskControllerHandler, taskInstance, contextInstance, token);
                }
                taskControllerHandler.submitTaskVariables(taskInstance, contextInstance, token);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else if (this.variableAccesses != null) {
            ArrayList<String> missingTaskVariables = null;
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                VariableAccess variableAccess = (VariableAccess)iter.next();
                String mappedName = variableAccess.getMappedName();
                if (!variableAccess.isRequired() || taskInstance.hasVariableLocally(mappedName)) continue;
                if (missingTaskVariables == null) {
                    missingTaskVariables = new ArrayList<String>();
                }
                missingTaskVariables.add(mappedName);
            }
            if (missingTaskVariables != null) {
                throw new IllegalArgumentException("missing task variables: " + missingTaskVariables);
            }
            Token token = taskInstance.getToken();
            ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
            boolean debug = log.isDebugEnabled();
            Iterator iter2 = this.variableAccesses.iterator();
            while (iter2.hasNext()) {
                String mappedName;
                Object value;
                VariableAccess variableAccess = (VariableAccess)iter2.next();
                if (!variableAccess.isWritable() || (value = taskInstance.getVariable(mappedName = variableAccess.getMappedName())) == null) continue;
                String variableName = variableAccess.getVariableName();
                if (debug) {
                    log.debug((Object)(taskInstance + " writes '" + variableName + "' from '" + mappedName + '\''));
                }
                contextInstance.setVariable(variableName, value, token);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskController)) {
            return false;
        }
        TaskController other = (TaskController)o;
        return this.id != 0L && this.id == other.getId();
    }

    public List getVariableAccesses() {
        return this.variableAccesses;
    }

    public Delegation getTaskControllerDelegation() {
        return this.taskControllerDelegation;
    }

    public void setTaskControllerDelegation(Delegation taskControllerDelegation) {
        this.taskControllerDelegation = taskControllerDelegation;
    }

    public long getId() {
        return this.id;
    }

    public void setVariableAccesses(List variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

