/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.logging.LoggingService;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.security.AuthenticationService;
import org.jbpm.security.AuthorizationService;
import org.jbpm.svc.JbpmServiceException;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.save.CascadeSaveOperation;
import org.jbpm.svc.save.CheckUnpersistableVariablesOperation;
import org.jbpm.svc.save.HibernateSaveOperation;
import org.jbpm.svc.save.SaveLogsOperation;
import org.jbpm.svc.save.SaveOperation;
import org.jbpm.tx.TxService;

public class Services
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICENAME_AUTHENTICATION = "authentication";
    public static final String SERVICENAME_AUTHORIZATION = "authorization";
    public static final String SERVICENAME_TX = "tx";
    public static final String SERVICENAME_LOGGING = "logging";
    public static final String SERVICENAME_MESSAGE = "message";
    public static final String SERVICENAME_PERSISTENCE = "persistence";
    public static final String SERVICENAME_SCHEDULER = "scheduler";
    public static final String SERVICENAME_JCR = "jcr";
    public static final String SERVICENAME_ADDRESSRESOLVER = "addressresolver";
    private static final List defaultSaveOperations = Services.createDefaultSaveOperations();
    private final Map serviceFactories;
    private final List serviceNames;
    private final Map services;
    private List saveOperations = defaultSaveOperations;
    private static final Log log = LogFactory.getLog((Class)Services.class);

    private static List createDefaultSaveOperations() {
        SaveOperation[] operations = new SaveOperation[]{new CheckUnpersistableVariablesOperation(), new HibernateSaveOperation(), new SaveLogsOperation(), new CascadeSaveOperation()};
        return Arrays.asList(operations);
    }

    public static Service getCurrentService(String name) {
        return Services.getCurrentService(name, true);
    }

    public static Service getCurrentService(String name, boolean isRequired) {
        Service service;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (service = jbpmContext.getServices().getService(name)) != null) {
            return service;
        }
        if (isRequired) {
            throw new JbpmServiceException("service unavailable: " + name);
        }
        return null;
    }

    public Services(Map serviceFactories) {
        this(serviceFactories, new ArrayList(serviceFactories.keySet()), null);
    }

    public Services(Map serviceFactories, List serviceNames, List saveOperations) {
        if (serviceFactories == null) {
            throw new IllegalArgumentException("service factories map is null");
        }
        this.serviceFactories = serviceFactories;
        this.serviceNames = serviceNames;
        this.services = new HashMap(serviceFactories.size());
        if (saveOperations != null) {
            this.saveOperations = saveOperations;
        }
    }

    public void setSaveOperations(List saveOperations) {
        if (saveOperations == null) {
            throw new IllegalArgumentException("save operations list is null");
        }
        this.saveOperations = saveOperations;
    }

    public void addSaveOperation(SaveOperation saveOperation) {
        if (saveOperation == null) {
            throw new IllegalArgumentException("save operation is null");
        }
        if (this.saveOperations == defaultSaveOperations) {
            this.saveOperations = new ArrayList(defaultSaveOperations);
        }
        this.saveOperations.add(saveOperation);
    }

    public Map getServiceFactories() {
        return this.serviceFactories;
    }

    public ServiceFactory getServiceFactory(String name) {
        return (ServiceFactory)this.getServiceFactories().get(name);
    }

    public boolean hasService(String name) {
        return this.services.containsKey(name);
    }

    public Service getService(String name) {
        ServiceFactory serviceFactory;
        Service service = (Service)this.services.get(name);
        if (service == null && (serviceFactory = this.getServiceFactory(name)) != null) {
            service = serviceFactory.openService();
            this.services.put(name, service);
        }
        return service;
    }

    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        if (this.saveOperations != defaultSaveOperations && log.isDebugEnabled()) {
            log.debug((Object)("executing custom save operations: " + this.saveOperations));
        }
        Iterator iter = this.saveOperations.iterator();
        while (iter.hasNext()) {
            SaveOperation saveOperation = (SaveOperation)iter.next();
            saveOperation.save(processInstance, jbpmContext);
        }
    }

    public AuthenticationService getAuthenticationService() {
        return (AuthenticationService)this.getService(SERVICENAME_AUTHENTICATION);
    }

    public AuthorizationService getAuthorizationService() {
        return (AuthorizationService)this.getService(SERVICENAME_AUTHORIZATION);
    }

    public LoggingService getLoggingService() {
        return (LoggingService)this.getService(SERVICENAME_LOGGING);
    }

    public MessageService getMessageService() {
        return (MessageService)this.getService(SERVICENAME_MESSAGE);
    }

    public PersistenceService getPersistenceService() {
        return (PersistenceService)this.getService(SERVICENAME_PERSISTENCE);
    }

    public SchedulerService getSchedulerService() {
        return (SchedulerService)this.getService(SERVICENAME_SCHEDULER);
    }

    public TxService getTxService() {
        return (TxService)this.getService(SERVICENAME_TX);
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.services.put(SERVICENAME_AUTHENTICATION, authenticationService);
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.services.put(SERVICENAME_AUTHORIZATION, authorizationService);
    }

    public void setLoggingService(LoggingService loggingService) {
        this.services.put(SERVICENAME_LOGGING, loggingService);
    }

    public void setMessageService(MessageService messageService) {
        this.services.put(SERVICENAME_MESSAGE, messageService);
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.services.put(SERVICENAME_PERSISTENCE, persistenceService);
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.services.put(SERVICENAME_SCHEDULER, schedulerService);
    }

    public void setTxService(TxService txService) {
        this.services.put(SERVICENAME_TX, txService);
    }

    public void close() {
        RuntimeException firstException = null;
        Iterator iter = this.serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            Service service = (Service)this.services.get(serviceName);
            if (service == null) continue;
            try {
                service.close();
            }
            catch (RuntimeException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                if (DbPersistenceService.isLockingException(e)) {
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("problem closing '" + serviceName + "' service"), (Throwable)e);
                    continue;
                }
                log.error((Object)("problem closing '" + serviceName + "' service"), (Throwable)e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static boolean isCausedByStaleState(JbpmPersistenceException persistenceException) {
        return DbPersistenceService.isLockingException(persistenceException);
    }

    public static void assignId(Object object) {
        Services services;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (services = jbpmContext.getServices()).hasService(SERVICENAME_PERSISTENCE)) {
            PersistenceService persistenceService = services.getPersistenceService();
            persistenceService.assignId(object);
        }
    }
}

