/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.jta.JtaDbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private UserTransaction transaction;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)JtaDbPersistenceService.class);

    public JtaDbPersistenceService(JtaDbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isTransactionActive()) {
            this.beginTransaction();
        }
    }

    public boolean isTransactionActive() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactory);
    }

    protected boolean isTransactionManagedExternally() {
        return this.transaction == null;
    }

    protected boolean isTransactionRollbackOnly() {
        return super.isTransactionRollbackOnly() || JTAHelper.isMarkedForRollback((int)this.getTransactionStatus());
    }

    public void beginTransaction() {
        try {
            JtaDbPersistenceServiceFactory jtaFactory = (JtaDbPersistenceServiceFactory)this.persistenceServiceFactory;
            this.transaction = jtaFactory.getUserTransaction();
            this.transaction.begin();
        }
        catch (NotSupportedException e) {
            throw new JbpmException("transaction is already in course", e);
        }
        catch (SystemException e) {
            throw new JbpmException("transaction begin failed", e);
        }
    }

    private int getTransactionStatus() {
        try {
            if (this.transaction != null) {
                return this.transaction.getStatus();
            }
            SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
            TransactionManager transactionManager = sessionFactory.getTransactionManager();
            if (transactionManager != null) {
                return transactionManager.getStatus();
            }
        }
        catch (SystemException e) {
            log.error((Object)"could not get transaction status", (Throwable)e);
        }
        return 5;
    }

    protected Exception commit() {
        if (this.transaction != null) {
            try {
                this.transaction.commit();
            }
            catch (RollbackException e) {
                return e;
            }
            catch (HeuristicMixedException e) {
                return e;
            }
            catch (HeuristicRollbackException e) {
                return e;
            }
            catch (SystemException e) {
                return e;
            }
        }
        return null;
    }

    protected Exception rollback() {
        if (this.transaction != null) {
            try {
                this.transaction.rollback();
            }
            catch (SystemException e) {
                return e;
            }
        }
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        TransactionManager transactionManager = sessionFactory.getTransactionManager();
        if (transactionManager == null) {
            throw new JbpmPersistenceException("cannot honor rollback request under external transaction manager");
        }
        try {
            transactionManager.getTransaction().setRollbackOnly();
        }
        catch (SystemException e) {
            return e;
        }
        return null;
    }

    public boolean isJtaTxCreated() {
        return !this.isTransactionManagedExternally();
    }
}

