/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.JpdlParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.mail.Mail;
import org.jbpm.scheduler.def.CancelTimerAction;
import org.jbpm.scheduler.def.CreateTimerAction;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.xml.sax.InputSource;

public class JpdlXmlReader
implements ProblemListener {
    private static final long serialVersionUID = 1L;
    protected InputSource inputSource;
    protected List problems = new ArrayList();
    protected ProblemListener problemListener;
    protected ProcessDefinition processDefinition;
    protected String initialNodeName;
    protected Collection unresolvedTransitionDestinations = new ArrayList();
    protected Collection unresolvedActionReferences = new ArrayList();
    protected Document document;
    private int timerNumber;

    public JpdlXmlReader(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public JpdlXmlReader(InputSource inputSource, ProblemListener problemListener) {
        this.inputSource = inputSource;
        this.problemListener = problemListener;
    }

    public JpdlXmlReader(Reader reader) {
        this(new InputSource(reader));
    }

    public void close() throws IOException {
        InputStream byteStream = this.inputSource.getByteStream();
        if (byteStream != null) {
            byteStream.close();
        } else {
            Reader charStream = this.inputSource.getCharacterStream();
            if (charStream != null) {
                charStream.close();
            }
        }
        this.document = null;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void addProblem(Problem problem) {
        this.problems.add(problem);
        if (this.problemListener != null) {
            this.problemListener.addProblem(problem);
        }
    }

    public void addError(String description) {
        this.addProblem(new Problem(2, description));
    }

    public void addError(String description, Throwable exception) {
        this.addProblem(new Problem(2, description, exception));
    }

    public void addWarning(String description) {
        this.addProblem(new Problem(3, description));
    }

    public ProcessDefinition readProcessDefinition() {
        this.processDefinition = ProcessDefinition.createNewProcessDefinition();
        this.problems.clear();
        this.unresolvedTransitionDestinations.clear();
        this.unresolvedActionReferences.clear();
        try {
            this.document = JpdlParser.parse(this.inputSource, this);
            Element root = this.document.getRootElement();
            this.parseProcessDefinitionAttributes(root);
            String description = root.elementTextTrim("description");
            if (description != null) {
                this.processDefinition.setDescription(description);
            }
            this.readSwimlanes(root);
            this.readActions(root, null, null);
            this.readNodes(root, this.processDefinition);
            this.readEvents(root, this.processDefinition);
            this.readExceptionHandlers(root, this.processDefinition);
            this.readTasks(root, null);
            this.resolveTransitionDestinations();
            this.resolveActionReferences();
            this.verifySwimlaneAssignments();
            if (Problem.containsProblemsOfLevel(this.problems, 2)) {
                throw new JpdlException(this.problems);
            }
        }
        catch (DocumentException e) {
            throw new JpdlException("failed to parse process document", e);
        }
        return this.processDefinition;
    }

    protected void parseProcessDefinitionAttributes(Element root) {
        this.processDefinition.setName(root.attributeValue("name"));
        this.initialNodeName = root.attributeValue("initial");
    }

    protected void readSwimlanes(Element processDefinitionElement) {
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        Iterator iter = processDefinitionElement.elementIterator("swimlane");
        while (iter.hasNext()) {
            Element swimlaneElement = (Element)iter.next();
            String swimlaneName = swimlaneElement.attributeValue("name");
            if (swimlaneName == null) {
                this.addWarning("there's a swimlane without a name");
                continue;
            }
            Swimlane swimlane = new Swimlane(swimlaneName);
            Element assignmentElement = swimlaneElement.element("assignment");
            if (assignmentElement != null) {
                if (assignmentElement.attribute("actor-id") != null || assignmentElement.attribute("pooled-actors") != null) {
                    swimlane.setActorIdExpression(assignmentElement.attributeValue("actor-id"));
                    swimlane.setPooledActorsExpression(assignmentElement.attributeValue("pooled-actors"));
                } else {
                    Delegation assignmentDelegation = this.readAssignmentDelegation(assignmentElement);
                    swimlane.setAssignmentDelegation(assignmentDelegation);
                }
            } else {
                Task startTask = taskMgmtDefinition.getStartTask();
                if (startTask == null || startTask.getSwimlane() != swimlane) {
                    this.addWarning("swimlane '" + swimlaneName + "' does not have an assignment");
                }
            }
            taskMgmtDefinition.addSwimlane(swimlane);
        }
    }

    public void readNodes(Element element, NodeCollection nodeCollection) {
        Iterator iter = element.elementIterator();
        while (iter.hasNext()) {
            Element nodeElement = (Element)iter.next();
            String nodeName = nodeElement.getName();
            Class nodeType = NodeTypes.getNodeType(nodeName);
            if (nodeType == null) continue;
            try {
                Node node = (Node)nodeType.newInstance();
                node.setProcessDefinition(this.processDefinition);
                if (node instanceof StartState && this.processDefinition.getStartState() != null) {
                    this.addError("max one start-state allowed in a process");
                    continue;
                }
                this.readNode(nodeElement, node, nodeCollection);
                node.read(nodeElement, this);
            }
            catch (InstantiationException e) {
                throw new JbpmException("failed to instantiate " + nodeType, e);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(this.getClass() + " has no access to " + nodeType, e);
            }
        }
    }

    public void readTasks(Element element, TaskNode taskNode) {
        List elements = element.elements("task");
        TaskMgmtDefinition tmd = (TaskMgmtDefinition)this.processDefinition.getDefinition(TaskMgmtDefinition.class);
        if (elements.size() > 0) {
            if (tmd == null) {
                tmd = new TaskMgmtDefinition();
            }
            this.processDefinition.addDefinition(tmd);
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Element taskElement = (Element)iter.next();
                this.readTask(taskElement, tmd, taskNode);
            }
        }
    }

    public Task readTask(Element taskElement, TaskMgmtDefinition taskMgmtDefinition, TaskNode taskNode) {
        Element taskControllerElement;
        Task task = new Task();
        task.setProcessDefinition(this.processDefinition);
        String name = taskElement.attributeValue("name");
        if (name != null) {
            task.setName(name);
            taskMgmtDefinition.addTask(task);
        } else if (taskNode != null) {
            task.setName(taskNode.getName());
            taskMgmtDefinition.addTask(task);
        }
        String description = taskElement.elementTextTrim("description");
        if (description != null) {
            task.setDescription(description);
        } else {
            task.setDescription(taskElement.attributeValue("description"));
        }
        String condition = taskElement.elementTextTrim("condition");
        if (condition != null) {
            task.setCondition(condition);
        } else {
            task.setCondition(taskElement.attributeValue("condition"));
        }
        this.readTaskTimers(taskElement, task);
        this.readEvents(taskElement, task);
        this.readExceptionHandlers(taskElement, task);
        String duedateText = taskElement.attributeValue("duedate");
        if (duedateText == null) {
            duedateText = taskElement.attributeValue("dueDate");
        }
        task.setDueDate(duedateText);
        String priorityText = taskElement.attributeValue("priority");
        if (priorityText != null) {
            task.setPriority(Task.parsePriority(priorityText));
        }
        if (taskNode != null) {
            taskNode.addTask(task);
        }
        String blockingText = taskElement.attributeValue("blocking");
        task.setBlocking(this.readBoolean(blockingText, false));
        String signallingText = taskElement.attributeValue("signalling");
        task.setSignalling(this.readBoolean(signallingText, true));
        String swimlaneName = taskElement.attributeValue("swimlane");
        Element assignmentElement = taskElement.element("assignment");
        if (swimlaneName != null) {
            Swimlane swimlane = taskMgmtDefinition.getSwimlane(swimlaneName);
            if (swimlane == null) {
                this.addWarning("task references unknown swimlane: " + taskElement.getPath());
            } else {
                task.setSwimlane(swimlane);
            }
        } else if (assignmentElement != null) {
            if (assignmentElement.attribute("actor-id") != null || assignmentElement.attribute("pooled-actors") != null) {
                task.setActorIdExpression(assignmentElement.attributeValue("actor-id"));
                task.setPooledActorsExpression(assignmentElement.attributeValue("pooled-actors"));
            } else {
                Delegation assignmentDelegation = this.readAssignmentDelegation(assignmentElement);
                task.setAssignmentDelegation(assignmentDelegation);
            }
        } else {
            this.addProblem(new Problem(4, "no assignment specified for task: " + taskElement.getPath()));
        }
        String notificationsText = taskElement.attributeValue("notify");
        if (this.readBoolean(notificationsText, false)) {
            String notificationEvent = "task-assign";
            Event event = task.getEvent(notificationEvent);
            if (event == null) {
                event = new Event(notificationEvent);
                task.addEvent(event);
            }
            Delegation delegation = this.createMailDelegation(notificationEvent, null, null, null, null);
            Action action = new Action(delegation);
            action.setProcessDefinition(this.processDefinition);
            action.setName(task.getName());
            event.addAction(action);
        }
        if ((taskControllerElement = taskElement.element("controller")) != null) {
            task.setTaskController(this.readTaskController(taskControllerElement));
        }
        return task;
    }

    public boolean readBoolean(String text, boolean defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(text) || "yes".equalsIgnoreCase(text) || "on".equalsIgnoreCase(text)) {
            return true;
        }
        if ("false".equalsIgnoreCase(text) || "no".equalsIgnoreCase(text) || "off".equalsIgnoreCase(text)) {
            return false;
        }
        return defaultValue;
    }

    protected Delegation readAssignmentDelegation(Element assignmentElement) {
        Delegation assignmentDelegation = new Delegation();
        String expression = assignmentElement.attributeValue("expression");
        String actorId = assignmentElement.attributeValue("actor-id");
        String pooledActors = assignmentElement.attributeValue("pooled-actors");
        if (expression != null) {
            assignmentDelegation.setProcessDefinition(this.processDefinition);
            assignmentDelegation.setClassName("org.jbpm.identity.assignment.ExpressionAssignmentHandler");
            assignmentDelegation.setConfiguration("<expression>" + expression + "</expression>");
        } else if (actorId != null || pooledActors != null) {
            assignmentDelegation.setProcessDefinition(this.processDefinition);
            assignmentDelegation.setClassName("org.jbpm.taskmgmt.assignment.ActorAssignmentHandler");
            String configuration = "";
            if (actorId != null) {
                configuration = configuration + "<actorId>" + actorId + "</actorId>";
            }
            if (pooledActors != null) {
                configuration = configuration + "<pooledActors>" + pooledActors + "</pooledActors>";
            }
            assignmentDelegation.setConfiguration(configuration);
        } else {
            assignmentDelegation = new Delegation();
            assignmentDelegation.read(assignmentElement, this);
        }
        return assignmentDelegation;
    }

    protected TaskController readTaskController(Element taskControllerElement) {
        TaskController taskController = new TaskController();
        if (taskControllerElement.attributeValue("class") != null) {
            Delegation taskControllerDelegation = new Delegation();
            taskControllerDelegation.read(taskControllerElement, this);
            taskController.setTaskControllerDelegation(taskControllerDelegation);
        } else {
            List variableAccesses = this.readVariableAccesses(taskControllerElement);
            taskController.setVariableAccesses(variableAccesses);
        }
        return taskController;
    }

    public List readVariableAccesses(Element element) {
        ArrayList<VariableAccess> variableAccesses = new ArrayList<VariableAccess>();
        Iterator iter = element.elementIterator("variable");
        while (iter.hasNext()) {
            Element variableElement = (Element)iter.next();
            String variableName = variableElement.attributeValue("name");
            if (variableName == null) {
                this.addWarning("variable name not specified: " + variableElement.getPath());
            }
            String access = variableElement.attributeValue("access", "read,write");
            String mappedName = variableElement.attributeValue("mapped-name");
            variableAccesses.add(new VariableAccess(variableName, access, mappedName));
        }
        return variableAccesses;
    }

    public void readStartStateTask(Element startTaskElement, StartState startState) {
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        Task startTask = this.readTask(startTaskElement, taskMgmtDefinition, null);
        startTask.setStartState(startState);
        if (startTask.getName() == null) {
            startTask.setName(startState.getName());
        }
        taskMgmtDefinition.setStartTask(startTask);
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        String asyncText;
        String description;
        nodeCollection.addNode(node);
        String name = nodeElement.attributeValue("name");
        if (name != null) {
            node.setName(name);
            if (this.initialNodeName != null && this.initialNodeName.equals(node.getFullyQualifiedName())) {
                this.processDefinition.setStartState(node);
            }
        }
        if ((description = nodeElement.elementTextTrim("description")) != null) {
            node.setDescription(description);
        }
        if ("exclusive".equalsIgnoreCase(asyncText = nodeElement.attributeValue("async"))) {
            node.setAsyncExclusive(true);
        } else if (this.readBoolean(asyncText, false)) {
            node.setAsync(true);
        }
        this.readNodeTimers(nodeElement, node);
        this.readEvents(nodeElement, node);
        this.readExceptionHandlers(nodeElement, node);
        this.addUnresolvedTransitionDestination(nodeElement, node);
    }

    protected void readNodeTimers(Element nodeElement, Node node) {
        Iterator iter = nodeElement.elementIterator("timer");
        while (iter.hasNext()) {
            Element timerElement = (Element)iter.next();
            this.readNodeTimer(timerElement, node);
        }
    }

    protected void readNodeTimer(Element timerElement, Node node) {
        String name = timerElement.attributeValue("name", node.getName());
        if (name == null) {
            name = this.generateTimerName();
        }
        CreateTimerAction createTimerAction = new CreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        createTimerAction.setTimerAction(this.readSingleAction(timerElement));
        this.addAction(node, "node-enter", createTimerAction);
        CancelTimerAction cancelTimerAction = new CancelTimerAction();
        cancelTimerAction.setTimerName(name);
        this.addAction(node, "node-leave", cancelTimerAction);
    }

    private String generateTimerName() {
        return "timer-" + this.timerNumber++;
    }

    protected void readTaskTimers(Element taskElement, Task task) {
        Iterator iter = taskElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            String elementName = element.getName();
            if (!"timer".equals(elementName) && !"reminder".equals(elementName)) continue;
            this.readTaskTimer(element, task);
        }
    }

    protected void readTaskTimer(Element timerElement, Task task) {
        String name = timerElement.attributeValue("name", task.getName());
        if (name == null) {
            name = this.generateTimerName();
        }
        CreateTimerAction createTimerAction = new CreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        Action action = null;
        if ("timer".equals(timerElement.getName())) {
            action = this.readSingleAction(timerElement);
        } else {
            Delegation delegation = this.createMailDelegation("task-reminder", null, null, null, null);
            action = new Action(delegation);
        }
        createTimerAction.setTimerAction(action);
        this.addAction(task, "task-create", createTimerAction);
        String cancelEventText = timerElement.attributeValue("cancel-event");
        if (cancelEventText != null) {
            String[] cancelEventTypes = cancelEventText.split("[\\s,]+");
            if (cancelEventTypes.length > 1 || cancelEventTypes[0].length() > 0) {
                for (int i = 0; i < cancelEventTypes.length; ++i) {
                    CancelTimerAction cancelTimerAction = new CancelTimerAction();
                    cancelTimerAction.setTimerName(name);
                    this.addAction(task, cancelEventTypes[i], cancelTimerAction);
                }
            }
        } else {
            CancelTimerAction cancelTimerAction = new CancelTimerAction();
            cancelTimerAction.setTimerName(name);
            this.addAction(task, "task-end", cancelTimerAction);
        }
    }

    protected void readEvents(Element parentElement, GraphElement graphElement) {
        Iterator iter = parentElement.elementIterator("event");
        while (iter.hasNext()) {
            Element eventElement = (Element)iter.next();
            String eventType = eventElement.attributeValue("type");
            if (!graphElement.hasEvent(eventType)) {
                graphElement.addEvent(new Event(eventType));
            }
            this.readActions(eventElement, graphElement, eventType);
        }
    }

    public void readActions(Element eventElement, GraphElement graphElement, String eventType) {
        Iterator iter = eventElement.elementIterator();
        while (iter.hasNext()) {
            Element actionElement = (Element)iter.next();
            if (!ActionTypes.hasActionName(actionElement.getName())) continue;
            Action action = this.createAction(actionElement);
            if (graphElement == null || eventType == null) continue;
            this.addAction(graphElement, eventType, action);
        }
    }

    protected void addAction(GraphElement graphElement, String eventType, Action action) {
        Event event = graphElement.getEvent(eventType);
        if (event == null) {
            event = new Event(eventType);
            graphElement.addEvent(event);
        }
        event.addAction(action);
    }

    public Action readSingleAction(Element nodeElement) {
        Iterator iter = nodeElement.elementIterator();
        while (iter.hasNext()) {
            Element candidate = (Element)iter.next();
            if (!ActionTypes.hasActionName(candidate.getName())) continue;
            return this.createAction(candidate);
        }
        return null;
    }

    public Action createAction(Element actionElement) {
        String actionName = actionElement.getName();
        Class actionType = ActionTypes.getActionType(actionName);
        try {
            Action action = (Action)actionType.newInstance();
            this.readAction(actionElement, action);
            action.read(actionElement, this);
            return action;
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + actionType, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + actionType, e);
        }
    }

    public void readAction(Element actionElement, Action action) {
        String actionName = actionElement.attributeValue("name");
        if (actionName != null) {
            action.setName(actionName);
            this.processDefinition.addAction(action);
        }
        String acceptPropagatedEvents = actionElement.attributeValue("accept-propagated-events");
        action.setPropagationAllowed(this.readBoolean(acceptPropagatedEvents, true));
        String asyncText = actionElement.attributeValue("async");
        if ("exclusive".equalsIgnoreCase(asyncText)) {
            action.setAsyncExclusive(true);
        } else if (this.readBoolean(asyncText, false)) {
            action.setAsync(true);
        }
    }

    protected void readExceptionHandlers(Element graphDomElement, GraphElement graphElement) {
        Iterator iter = graphDomElement.elementIterator("exception-handler");
        while (iter.hasNext()) {
            Element exceptionHandlerElement = (Element)iter.next();
            this.readExceptionHandler(exceptionHandlerElement, graphElement);
        }
    }

    protected void readExceptionHandler(Element exceptionHandlerElement, GraphElement graphElement) {
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        exceptionHandler.setExceptionClassName(exceptionHandlerElement.attributeValue("exception-class"));
        graphElement.addExceptionHandler(exceptionHandler);
        Iterator iter = exceptionHandlerElement.elementIterator();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            if (!ActionTypes.hasActionName(childElement.getName())) continue;
            Action action = this.createAction(childElement);
            exceptionHandler.addAction(action);
        }
    }

    public void addUnresolvedTransitionDestination(Element nodeElement, Node node) {
        this.unresolvedTransitionDestinations.add(new Object[]{nodeElement, node});
    }

    public void resolveTransitionDestinations() {
        Iterator iter = this.unresolvedTransitionDestinations.iterator();
        while (iter.hasNext()) {
            Object[] unresolvedTransition = (Object[])iter.next();
            Element nodeElement = (Element)unresolvedTransition[0];
            Node node = (Node)unresolvedTransition[1];
            this.resolveTransitionDestinations(nodeElement.elements("transition"), node);
        }
    }

    public void resolveTransitionDestinations(List transitionElements, Node node) {
        Iterator iter = transitionElements.iterator();
        while (iter.hasNext()) {
            Element transitionElement = (Element)iter.next();
            this.resolveTransitionDestination(transitionElement, node);
        }
    }

    public Transition resolveTransitionDestination(Element transitionElement, Node node) {
        Element conditionElement;
        Transition transition = new Transition();
        transition.setProcessDefinition(this.processDefinition);
        transition.setName(transitionElement.attributeValue("name"));
        transition.setDescription(transitionElement.elementTextTrim("description"));
        String condition = transitionElement.attributeValue("condition");
        if (condition == null && (conditionElement = transitionElement.element("condition")) != null && ((condition = conditionElement.getTextTrim()) == null || condition.length() == 0)) {
            condition = conditionElement.attributeValue("expression");
        }
        transition.setCondition(condition);
        node.addLeavingTransition(transition);
        String toName = transitionElement.attributeValue("to");
        if (toName == null) {
            this.addWarning("node '" + node.getFullyQualifiedName() + "' has a transition without a 'to'-attribute");
        } else {
            Node to = ((NodeCollection)((Object)node.getParent())).findNode(toName);
            if (to == null) {
                this.addWarning("transition to '" + toName + "' from " + node + " cannot be resolved");
            } else {
                to.addArrivingTransition(transition);
            }
        }
        this.readActions(transitionElement, transition, "transition");
        this.readExceptionHandlers(transitionElement, transition);
        return transition;
    }

    public void addUnresolvedActionReference(Element actionElement, Action action) {
        this.unresolvedActionReferences.add(new Object[]{actionElement, action});
    }

    public void resolveActionReferences() {
        Iterator iter = this.unresolvedActionReferences.iterator();
        while (iter.hasNext()) {
            Object[] unresolvedActionReference = (Object[])iter.next();
            Element actionElement = (Element)unresolvedActionReference[0];
            Action action = (Action)unresolvedActionReference[1];
            String referencedActionName = actionElement.attributeValue("ref-name");
            Action referencedAction = this.processDefinition.getAction(referencedActionName);
            if (referencedAction == null) {
                this.addWarning("referenced action not found: " + actionElement.getPath());
            }
            action.setReferencedAction(referencedAction);
        }
    }

    public void verifySwimlaneAssignments() {
        Map swimlanes;
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        if (taskMgmtDefinition != null && (swimlanes = taskMgmtDefinition.getSwimlanes()) != null) {
            Iterator iter = swimlanes.values().iterator();
            while (iter.hasNext()) {
                Swimlane startTaskSwimlane;
                Swimlane swimlane = (Swimlane)iter.next();
                Task startTask = taskMgmtDefinition.getStartTask();
                Swimlane swimlane2 = startTaskSwimlane = startTask != null ? startTask.getSwimlane() : null;
                if (swimlane.getAssignmentDelegation() != null || swimlane == startTaskSwimlane) continue;
                this.addWarning("swimlane '" + swimlane.getName() + "' does not have an assignment");
            }
        }
    }

    public Delegation createMailDelegation(String template, String actors, String to, String subject, String text) {
        StringBuffer config = new StringBuffer();
        if (template != null) {
            config.append("<template>");
            config.append(template);
            config.append("</template>");
        }
        if (actors != null) {
            config.append("<actors>");
            config.append(actors);
            config.append("</actors>");
        }
        if (to != null) {
            config.append("<to>");
            config.append(to);
            config.append("</to>");
        }
        if (subject != null) {
            config.append("<subject>");
            config.append(subject);
            config.append("</subject>");
        }
        if (text != null) {
            config.append("<text>");
            config.append(text);
            config.append("</text>");
        }
        String mailClassName = Mail.class.getName();
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.class.name")) {
            mailClassName = JbpmConfiguration.Configs.getString("jbpm.mail.class.name");
        } else if (JbpmConfiguration.Configs.hasObject("mail.class.name")) {
            mailClassName = JbpmConfiguration.Configs.getString("mail.class.name");
        }
        Delegation delegation = new Delegation(mailClassName);
        delegation.setProcessDefinition(this.processDefinition);
        delegation.setConfiguration(config.toString());
        return delegation;
    }

    public Delegation readMailDelegation(Element element) {
        String text;
        String subject;
        String bccActors;
        String bcc;
        String ccActors;
        String cc;
        String actors;
        String to;
        StringBuffer config = new StringBuffer();
        String template = element.attributeValue("template");
        if (template != null) {
            config.append("<template>").append(template).append("</template>");
        }
        if ((to = element.attributeValue("to")) != null) {
            config.append("<to>").append(to).append("</to>");
        }
        if ((actors = element.attributeValue("actors")) != null) {
            config.append("<actors>").append(actors).append("</actors>");
        }
        if ((cc = element.attributeValue("cc")) != null) {
            config.append("<cc>").append(cc).append("</cc>");
        }
        if ((ccActors = element.attributeValue("cc-actors")) != null) {
            config.append("<ccActors>").append(ccActors).append("</ccActors>");
        }
        if ((bcc = element.attributeValue("cc")) != null) {
            config.append("<bcc>").append(bcc).append("</bcc>");
        }
        if ((bccActors = element.attributeValue("bcc-actors")) != null) {
            config.append("<bccActors>").append(bccActors).append("</bccActors>");
        }
        if ((subject = this.getProperty("subject", element)) != null) {
            config.append("<subject>").append(subject).append("</subject>");
        }
        if ((text = this.getProperty("text", element)) != null) {
            config.append("<text>").append(text).append("</text>");
        }
        String mailClassName = JbpmConfiguration.Configs.hasObject("jbpm.mail.class.name") ? JbpmConfiguration.Configs.getString("jbpm.mail.class.name") : Mail.class.getName();
        Delegation delegation = new Delegation(mailClassName);
        delegation.setProcessDefinition(this.processDefinition);
        delegation.setConfiguration(config.toString());
        return delegation;
    }

    public String getProperty(String property, Element element) {
        Element propertyElement;
        String value = element.attributeValue(property);
        if (value == null && (propertyElement = element.element(property)) != null) {
            value = propertyElement.getText();
        }
        return value;
    }
}

