/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import java.util.regex.Pattern;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ExpressionEvaluator;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;

public class JbpmExpressionEvaluator {
    private static ExpressionEvaluator expressionEvaluator;
    private static VariableResolver variableResolver;
    private static FunctionMapper functionMapper;
    private static Pattern hashPattern;

    private static ExpressionEvaluator getExpressionEvaluator() {
        return expressionEvaluator != null ? expressionEvaluator : (ExpressionEvaluator)JbpmConfiguration.Configs.getObject("jbpm.expression.evaluator");
    }

    public static void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        JbpmExpressionEvaluator.expressionEvaluator = expressionEvaluator;
    }

    public static void setVariableResolver(VariableResolver variableResolver) {
        JbpmExpressionEvaluator.variableResolver = variableResolver;
    }

    public static void setFunctionMapper(FunctionMapper functionMapper) {
        JbpmExpressionEvaluator.functionMapper = functionMapper;
    }

    public static Object evaluate(String expression, ExecutionContext executionContext) {
        return JbpmExpressionEvaluator.evaluate(expression, executionContext, Object.class);
    }

    public static Object evaluate(String expression, ExecutionContext executionContext, Class expectedType) {
        return JbpmExpressionEvaluator.evaluate(expression, executionContext, expectedType, JbpmExpressionEvaluator.getVariableResolver(), JbpmExpressionEvaluator.getFunctionMapper());
    }

    public static Object evaluate(String expression, ExecutionContext executionContext, VariableResolver variableResolver, FunctionMapper functionMapper) {
        return JbpmExpressionEvaluator.evaluate(expression, executionContext, Object.class, variableResolver, functionMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluate(String expression, ExecutionContext executionContext, Class expectedType, VariableResolver variableResolver, FunctionMapper functionMapper) {
        ExecutionContext.pushCurrentContext(executionContext);
        try {
            Object object = JbpmExpressionEvaluator.getExpressionEvaluator().evaluate(JbpmExpressionEvaluator.translateExpressionToDollars(expression), expectedType, variableResolver, functionMapper);
            return object;
        }
        finally {
            ExecutionContext.popCurrentContext(executionContext);
        }
    }

    private static String translateExpressionToDollars(String expression) {
        return hashPattern.matcher(expression).replaceAll("\\${$1}");
    }

    public static VariableResolver getUsedVariableResolver() {
        return JbpmExpressionEvaluator.getVariableResolver();
    }

    public static VariableResolver getVariableResolver() {
        return variableResolver != null ? variableResolver : (VariableResolver)JbpmConfiguration.Configs.getObject("jbpm.variable.resolver");
    }

    public static FunctionMapper getUsedFunctionMapper() {
        return JbpmExpressionEvaluator.getFunctionMapper();
    }

    public static FunctionMapper getFunctionMapper() {
        return functionMapper != null ? functionMapper : (JbpmConfiguration.Configs.hasObject("jbpm.function.mapper") ? (FunctionMapper)JbpmConfiguration.Configs.getObject("jbpm.function.mapper") : null);
    }

    static {
        hashPattern = Pattern.compile("\\#\\{([^\\}]*)\\}");
    }
}

