/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ExecutionContext {
    protected Token token;
    protected Event event;
    protected GraphElement eventSource;
    protected Action action;
    protected Throwable exception;
    protected Transition transition;
    protected Node transitionSource;
    protected Task task;
    protected Timer timer;
    protected TaskInstance taskInstance;
    protected ProcessInstance subProcessInstance;
    static ThreadLocal threadLocalContextStack = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayList();
        }
    };
    private static final Log log = LogFactory.getLog((Class)ExecutionContext.class);

    public ExecutionContext(Token token) {
        this.token = token;
    }

    public ExecutionContext(ExecutionContext other) {
        this.token = other.token;
        this.event = other.event;
        this.action = other.action;
    }

    public Node getNode() {
        return this.token.getNode();
    }

    public ProcessDefinition getProcessDefinition() {
        ProcessInstance processInstance = this.getProcessInstance();
        return processInstance != null ? processInstance.getProcessDefinition() : null;
    }

    public void setAction(Action action) {
        this.action = action;
        if (action != null) {
            this.event = action.getEvent();
        }
    }

    public ProcessInstance getProcessInstance() {
        return this.token.getProcessInstance();
    }

    public String toString() {
        return "ExecutionContext(" + this.token.getName() + ')';
    }

    public void setVariable(String name, Object value) {
        if (this.taskInstance != null) {
            this.taskInstance.setVariable(name, value);
        } else {
            this.getContextInstance().setVariable(name, value, this.token);
        }
    }

    public Object getVariable(String name) {
        return this.taskInstance != null ? this.taskInstance.getVariable(name) : this.getContextInstance().getVariable(name, this.token);
    }

    public void leaveNode() {
        this.getNode().leave(this);
    }

    public void leaveNode(String transitionName) {
        this.getNode().leave(this, transitionName);
    }

    public void leaveNode(Transition transition) {
        this.getNode().leave(this, transition);
    }

    public ModuleDefinition getDefinition(Class clazz) {
        return this.getProcessDefinition().getDefinition(clazz);
    }

    public ModuleInstance getInstance(Class clazz) {
        ProcessInstance processInstance;
        if (this.token != null && (processInstance = this.token.getProcessInstance()) != null) {
            return processInstance.getInstance(clazz);
        }
        return null;
    }

    public ContextInstance getContextInstance() {
        return (ContextInstance)this.getInstance(ContextInstance.class);
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return (TaskMgmtInstance)this.getInstance(TaskMgmtInstance.class);
    }

    public JbpmContext getJbpmContext() {
        return JbpmContext.getCurrentJbpmContext();
    }

    public void setTaskInstance(TaskInstance taskInstance) {
        this.taskInstance = taskInstance;
        this.task = taskInstance != null ? taskInstance.getTask() : null;
    }

    public Token getToken() {
        return this.token;
    }

    public Action getAction() {
        return this.action;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Node getTransitionSource() {
        return this.transitionSource;
    }

    public void setTransitionSource(Node transitionSource) {
        this.transitionSource = transitionSource;
    }

    public GraphElement getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(GraphElement eventSource) {
        this.eventSource = eventSource;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public ProcessInstance getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public void setSubProcessInstance(ProcessInstance subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    static List getContextStack() {
        return (List)threadLocalContextStack.get();
    }

    public static void pushCurrentContext(ExecutionContext executionContext) {
        ExecutionContext.getContextStack().add(executionContext);
    }

    public static void popCurrentContext(ExecutionContext executionContext) {
        List stack = ExecutionContext.getContextStack();
        int index = stack.lastIndexOf(executionContext);
        if (index == -1) {
            log.warn((Object)(executionContext + " was not found in thread-local stack;" + " do not access ExecutionContext instances from multiple threads"));
        } else {
            if (index < stack.size() - 1) {
                log.warn((Object)(executionContext + " was not popped in reverse push order;" + " make sure you pop every context you push"));
            }
            stack.remove(index);
        }
    }

    public static ExecutionContext currentExecutionContext() {
        List stack = ExecutionContext.getContextStack();
        return stack.isEmpty() ? null : (ExecutionContext)stack.get(stack.size() - 1);
    }
}

