/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.def.ContextDefinition;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.node.ProcessFactory;
import org.jbpm.graph.node.StartState;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.util.ClassLoaderUtil;
import org.xml.sax.InputSource;

public class ProcessDefinition
extends GraphElement
implements NodeCollection {
    private static final long serialVersionUID = 1L;
    protected int version = -1;
    protected boolean isTerminationImplicit;
    protected Node startState;
    protected List nodes;
    private transient Map nodesMap;
    protected Map actions;
    protected Map definitions;
    private static final Map moduleClassesByResource = new HashMap();
    private static final String[] EVENT_TYPES = new String[]{"process-start", "process-end", "node-enter", "node-leave", "task-create", "task-assign", "task-start", "task-end", "transition", "before-signal", "after-signal", "superstate-enter", "superstate-leave", "subprocess-created", "subprocess-end", "timer"};
    public static final String[] supportedEventTypes = (String[])EVENT_TYPES.clone();

    public String[] getSupportedEventTypes() {
        return (String[])EVENT_TYPES.clone();
    }

    public ProcessDefinition() {
        this.processDefinition = this;
    }

    public static ProcessDefinition createNewProcessDefinition() {
        ProcessDefinition processDefinition = new ProcessDefinition();
        List moduleClasses = ProcessDefinition.getModuleClasses();
        Iterator iter = moduleClasses.iterator();
        while (iter.hasNext()) {
            Class moduleClass = (Class)iter.next();
            try {
                ModuleDefinition moduleDefinition = (ModuleDefinition)moduleClass.newInstance();
                processDefinition.addDefinition(moduleDefinition);
            }
            catch (InstantiationException e) {
                throw new JbpmException("failed to instantiate " + moduleClass, e);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException(ProcessDefinition.class + " has no access to " + moduleClass, e);
            }
        }
        return processDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getModuleClasses() {
        String resource = JbpmConfiguration.Configs.getString("resource.default.modules");
        Map map = moduleClassesByResource;
        synchronized (map) {
            List moduleClasses = (List)moduleClassesByResource.get(resource);
            if (moduleClasses == null) {
                moduleClasses = ProcessDefinition.loadModuleClasses(resource);
                moduleClassesByResource.put(resource, moduleClasses);
            }
            return moduleClasses;
        }
    }

    private static List loadModuleClasses(String resource) {
        Properties properties = ClassLoaderUtil.getProperties(resource);
        ArrayList<Class> moduleClasses = new ArrayList<Class>();
        Log log = LogFactory.getLog((Class)ProcessDefinition.class);
        boolean debug = log.isDebugEnabled();
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String moduleClassName = (String)iter.next();
            try {
                Class moduleClass = ClassLoaderUtil.classForName(moduleClassName);
                moduleClasses.add(moduleClass);
                if (!debug) continue;
                log.debug((Object)("loaded module " + moduleClassName));
            }
            catch (ClassNotFoundException e) {
                if (!debug) continue;
                log.debug((Object)("module class not found: " + moduleClassName), (Throwable)e);
            }
        }
        return moduleClasses;
    }

    public ProcessDefinition(String name) {
        this();
        this.name = name;
    }

    public ProcessDefinition(String[] nodes, String[] transitions) {
        this();
        ProcessFactory.addNodesAndTransitions(this, nodes, transitions);
    }

    public ProcessInstance createProcessInstance() {
        return new ProcessInstance(this);
    }

    public ProcessInstance createProcessInstance(Map variables) {
        return new ProcessInstance(this, variables, null);
    }

    public ProcessInstance createProcessInstance(Map variables, String businessKey) {
        return new ProcessInstance(this, variables, businessKey);
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        if (!this.equals(processDefinition)) {
            throw new IllegalArgumentException("process definition cannot reference another process definition");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessDefinition)) {
            return false;
        }
        ProcessDefinition other = (ProcessDefinition)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        return this.name != null && this.name.equals(other.getName()) && this.version == other.getVersion();
    }

    public int hashCode() {
        if (this.name == null) {
            return super.hashCode();
        }
        int result = 224001527 + this.name.hashCode();
        result = 1568661329 * result + this.version;
        return result;
    }

    public static ProcessDefinition parseXmlString(String xml) {
        StringReader stringReader = new StringReader(xml);
        JpdlXmlReader jpdlReader = new JpdlXmlReader(new InputSource(stringReader));
        return jpdlReader.readProcessDefinition();
    }

    public static ProcessDefinition parseXmlResource(String xmlResource) {
        URL resourceURL = ClassLoaderUtil.getClassLoader().getResource(xmlResource);
        if (resourceURL == null) {
            throw new JpdlException("resource not found: " + xmlResource);
        }
        JpdlXmlReader jpdlReader = new JpdlXmlReader(new InputSource(resourceURL.toString()));
        return jpdlReader.readProcessDefinition();
    }

    public static ProcessDefinition parseXmlInputStream(InputStream inputStream) {
        JpdlXmlReader jpdlReader = new JpdlXmlReader(new InputSource(inputStream));
        return jpdlReader.readProcessDefinition();
    }

    public static ProcessDefinition parseXmlReader(Reader reader) {
        JpdlXmlReader jpdlReader = new JpdlXmlReader(new InputSource(reader));
        return jpdlReader.readProcessDefinition();
    }

    public static ProcessDefinition parseParZipInputStream(ZipInputStream zipInputStream) throws IOException {
        return new ProcessArchive(zipInputStream).parseProcessDefinition();
    }

    public static ProcessDefinition parseParResource(String parResource) throws IOException {
        return ProcessDefinition.parseParZipInputStream(new ZipInputStream(ClassLoaderUtil.getStream(parResource)));
    }

    public List getNodes() {
        return this.nodes;
    }

    public Map getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = new HashMap();
            if (this.nodes != null) {
                Iterator iter = this.nodes.iterator();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    this.nodesMap.put(node.getName(), node);
                }
            }
        }
        return this.nodesMap;
    }

    public Node getNode(String name) {
        if (this.nodes == null) {
            return null;
        }
        return (Node)this.getNodesMap().get(name);
    }

    public boolean hasNode(String name) {
        if (this.nodes == null) {
            return false;
        }
        return this.getNodesMap().containsKey(name);
    }

    public Node addNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        this.nodes.add(node);
        node.processDefinition = this;
        this.nodesMap = null;
        if (node instanceof StartState && this.startState == null) {
            this.startState = node;
        }
        return node;
    }

    public Node removeNode(Node node) {
        Node removedNode = null;
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (this.nodes != null && this.nodes.remove(node)) {
            removedNode = node;
            removedNode.processDefinition = null;
            this.nodesMap = null;
        }
        if (this.startState == removedNode) {
            this.startState = null;
        }
        return removedNode;
    }

    public void reorderNode(int oldIndex, int newIndex) {
        if (this.nodes == null || Math.min(oldIndex, newIndex) < 0 || Math.max(oldIndex, newIndex) >= this.nodes.size()) {
            throw new IndexOutOfBoundsException("could not move node from " + oldIndex + " to " + newIndex);
        }
        Object node = this.nodes.remove(oldIndex);
        this.nodes.add(newIndex, node);
    }

    public String generateNodeName() {
        return ProcessDefinition.generateNodeName(this.nodes);
    }

    public Node findNode(String hierarchicalName) {
        return ProcessDefinition.findNode(this, hierarchicalName);
    }

    public static String generateNodeName(List nodes) {
        String name;
        if (nodes == null) {
            name = "1";
        } else {
            int n = 1;
            while (ProcessDefinition.containsName(nodes, Integer.toString(n))) {
                ++n;
            }
            name = Integer.toString(n);
        }
        return name;
    }

    private static boolean containsName(List nodes, String name) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!name.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public static Node findNode(NodeCollection nodeCollection, String hierarchicalName) {
        String[] nameParts = hierarchicalName.split("/");
        if (nameParts.length == 1) {
            String nodeName = nameParts[0];
            return nodeName.length() > 0 ? nodeCollection.getNode(nodeName) : null;
        }
        GraphElement currentElement = (GraphElement)((Object)nodeCollection);
        int startIndex = 0;
        if (nameParts[0].length() == 0) {
            currentElement = currentElement.getProcessDefinition();
            startIndex = 1;
        }
        for (int i = startIndex; i < nameParts.length; ++i) {
            String namePart = nameParts[i];
            if ("..".equals(namePart)) {
                if (currentElement == null) {
                    return null;
                }
                currentElement = currentElement.getParent();
                continue;
            }
            if (!(currentElement instanceof NodeCollection)) {
                return null;
            }
            NodeCollection currentCollection = (NodeCollection)((Object)currentElement);
            currentElement = currentCollection.getNode(namePart);
        }
        return currentElement instanceof Node ? (Node)currentElement : null;
    }

    public void setStartState(StartState startState) {
        if (this.startState != startState && this.startState != null) {
            this.removeNode(this.startState);
        }
        this.startState = startState;
        if (startState != null) {
            this.addNode(startState);
        }
    }

    public GraphElement getParent() {
        return null;
    }

    public Action addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (action.getName() == null) {
            throw new IllegalArgumentException("action is unnamed");
        }
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        this.actions.put(action.getName(), action);
        action.processDefinition = this;
        return action;
    }

    public void removeAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (this.actions != null) {
            if (!this.actions.containsValue(action)) {
                throw new IllegalArgumentException("action is not present in process definition");
            }
            this.actions.remove(action.getName());
            action.processDefinition = null;
        }
    }

    public Action getAction(String name) {
        return this.actions != null ? (Action)this.actions.get(name) : null;
    }

    public Map getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions != null && !this.actions.isEmpty();
    }

    public Object createInstance() {
        return new ProcessInstance(this);
    }

    public ModuleDefinition addDefinition(ModuleDefinition moduleDefinition) {
        if (moduleDefinition == null) {
            throw new IllegalArgumentException("module definition is null");
        }
        if (this.definitions == null) {
            this.definitions = new HashMap();
        }
        this.definitions.put(moduleDefinition.getClass().getName(), moduleDefinition);
        moduleDefinition.setProcessDefinition(this);
        return moduleDefinition;
    }

    public ModuleDefinition removeDefinition(ModuleDefinition moduleDefinition) {
        if (moduleDefinition == null) {
            throw new IllegalArgumentException("module definition is null");
        }
        ModuleDefinition removedDefinition = null;
        if (this.definitions != null && (removedDefinition = (ModuleDefinition)this.definitions.remove(moduleDefinition.getClass().getName())) != null) {
            moduleDefinition.setProcessDefinition(null);
        }
        return removedDefinition;
    }

    public ModuleDefinition getDefinition(Class clazz) {
        ModuleDefinition moduleDefinition = null;
        if (this.definitions != null) {
            moduleDefinition = (ModuleDefinition)this.definitions.get(clazz.getName());
        }
        return moduleDefinition;
    }

    public ContextDefinition getContextDefinition() {
        return (ContextDefinition)this.getDefinition(ContextDefinition.class);
    }

    public FileDefinition getFileDefinition() {
        return (FileDefinition)this.getDefinition(FileDefinition.class);
    }

    public TaskMgmtDefinition getTaskMgmtDefinition() {
        return (TaskMgmtDefinition)this.getDefinition(TaskMgmtDefinition.class);
    }

    public Map getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map definitions) {
        this.definitions = definitions;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Node getStartState() {
        return this.startState;
    }

    public void setStartState(Node startState) {
        this.startState = startState;
    }

    public boolean isTerminationImplicit() {
        return this.isTerminationImplicit;
    }

    public void setTerminationImplicit(boolean isTerminationImplicit) {
        this.isTerminationImplicit = isTerminationImplicit;
    }
}

