/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.def;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.Delegation;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.taskmgmt.def.TaskControllerHandler;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.util.EqualsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    Delegation taskControllerDelegation = null;
    List<VariableAccess> variableAccesses = null;
    private static Log log = LogFactory.getLog(TaskController.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeVariables(TaskInstance taskInstance) {
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JbpmConfiguration.getProcessClassLoader(taskInstance.getTask().getProcessDefinition()));
            if (this.taskControllerDelegation != null) {
                TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
                ProcessInstance processInstance = taskInstance.getTaskMgmtInstance().getProcessInstance();
                ContextInstance contextInstance = processInstance != null ? processInstance.getContextInstance() : null;
                Token token = taskInstance.getToken();
                if (UserCodeInterceptorConfig.userCodeInterceptor != null) {
                    UserCodeInterceptorConfig.userCodeInterceptor.executeTaskControllerInitialization(taskControllerHandler, taskInstance, contextInstance, token);
                } else {
                    taskControllerHandler.initializeTaskVariables(taskInstance, contextInstance, token);
                }
            } else {
                Token token = taskInstance.getToken();
                ProcessInstance processInstance = token.getProcessInstance();
                ContextInstance contextInstance = processInstance.getContextInstance();
                if (this.variableAccesses != null) {
                    for (VariableAccess variableAccess : this.variableAccesses) {
                        String mappedName = variableAccess.getMappedName();
                        if (variableAccess.isReadable()) {
                            String variableName = variableAccess.getVariableName();
                            Object value = contextInstance.getVariable(variableName, token);
                            log.debug((Object)("creating task instance variable '" + mappedName + "' from process variable '" + variableName + "', value '" + value + "'"));
                            taskInstance.setVariableLocally(mappedName, value);
                            continue;
                        }
                        log.debug((Object)("creating task instance local variable '" + mappedName + "'. initializing with null value."));
                        taskInstance.setVariableLocally(mappedName, null);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitParameters(TaskInstance taskInstance) {
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JbpmConfiguration.getProcessClassLoader(taskInstance.getTask().getProcessDefinition()));
            if (this.taskControllerDelegation != null) {
                TaskControllerHandler taskControllerHandler = (TaskControllerHandler)this.taskControllerDelegation.instantiate();
                ProcessInstance processInstance = taskInstance.getTaskMgmtInstance().getProcessInstance();
                ContextInstance contextInstance = processInstance != null ? processInstance.getContextInstance() : null;
                Token token = taskInstance.getToken();
                if (UserCodeInterceptorConfig.userCodeInterceptor != null) {
                    UserCodeInterceptorConfig.userCodeInterceptor.executeTaskControllerSubmission(taskControllerHandler, taskInstance, contextInstance, token);
                } else {
                    taskControllerHandler.submitTaskVariables(taskInstance, contextInstance, token);
                }
            } else {
                Token token = taskInstance.getToken();
                ProcessInstance processInstance = token.getProcessInstance();
                ContextInstance contextInstance = processInstance.getContextInstance();
                if (this.variableAccesses != null) {
                    String mappedName;
                    String missingTaskVariables = null;
                    for (VariableAccess variableAccess : this.variableAccesses) {
                        mappedName = variableAccess.getMappedName();
                        if (!variableAccess.isRequired() || taskInstance.hasVariableLocally(mappedName)) continue;
                        if (missingTaskVariables == null) {
                            missingTaskVariables = mappedName;
                            continue;
                        }
                        missingTaskVariables = missingTaskVariables + ", " + mappedName;
                    }
                    if (missingTaskVariables != null) {
                        throw new IllegalArgumentException("missing task variables: " + missingTaskVariables);
                    }
                    for (VariableAccess variableAccess : this.variableAccesses) {
                        Object value;
                        mappedName = variableAccess.getMappedName();
                        String variableName = variableAccess.getVariableName();
                        if (!variableAccess.isWritable() || (value = taskInstance.getVariable(mappedName)) == null) continue;
                        log.debug((Object)("submitting task variable '" + mappedName + "' to process variable '" + variableName + "', value '" + value + "'"));
                        contextInstance.setVariable(variableName, value, token);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public List<VariableAccess> getVariableAccesses() {
        return this.variableAccesses;
    }

    public Delegation getTaskControllerDelegation() {
        return this.taskControllerDelegation;
    }

    public void setTaskControllerDelegation(Delegation taskControllerDelegation) {
        this.taskControllerDelegation = taskControllerDelegation;
    }

    public long getId() {
        return this.id;
    }

    public void setVariableAccesses(List<VariableAccess> variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

