/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.logging.exe;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    List<ProcessLog> logs = new ArrayList<ProcessLog>();
    transient List<CompositeLog> compositeLogStack = new ArrayList<CompositeLog>();
    private static final Log log = LogFactory.getLog(LoggingInstance.class);

    public void startCompositeLog(CompositeLog compositeLog) {
        this.addLog(compositeLog);
        this.compositeLogStack.add(compositeLog);
    }

    public void endCompositeLog() {
        this.compositeLogStack.remove(this.compositeLogStack.size() - 1);
    }

    public void addLog(ProcessLog processLog) {
        if (!this.compositeLogStack.isEmpty()) {
            CompositeLog currentCompositeLog = this.compositeLogStack.get(this.compositeLogStack.size() - 1);
            processLog.setParent(currentCompositeLog);
            currentCompositeLog.addChild(processLog);
        }
        processLog.setDate(Clock.getCurrentTime());
        this.logs.add(processLog);
    }

    public List<ProcessLog> getLogs() {
        return this.logs;
    }

    public <L extends ProcessLog> List<L> getLogs(Class<L> logType) {
        return LoggingInstance.getLogs(this.logs, logType);
    }

    public static <L extends ProcessLog> List<L> getLogs(Collection<ProcessLog> logs, Class<L> logType) {
        ArrayList<L> filteredLogs = new ArrayList<L>();
        if (logs != null) {
            for (ProcessLog log : logs) {
                if (!logType.isInstance(log)) continue;
                filteredLogs.add(logType.cast(log));
            }
        }
        return filteredLogs;
    }

    List<CompositeLog> getCompositeLogStack() {
        return this.compositeLogStack;
    }

    public void logLogs() {
        for (ProcessLog processLog : this.logs) {
            if (processLog.getParent() != null) continue;
            this.logLog("", processLog);
        }
    }

    void logLog(String indentation, ProcessLog processLog) {
        CompositeLog compositeLog;
        List<ProcessLog> children;
        boolean isComposite = processLog instanceof CompositeLog;
        log.debug((Object)(indentation + (isComposite ? "+ [" : "  [") + processLog.getIndex() + "] " + processLog + " on " + processLog.getToken()));
        if (isComposite && (children = (compositeLog = (CompositeLog)processLog).getChildren()) != null) {
            for (ProcessLog childLog : children) {
                this.logLog(indentation + "  ", childLog);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.compositeLogStack = new ArrayList<CompositeLog>();
    }
}

