/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.instantiation.InstantiatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPropertyInstantiator
implements Instantiator {
    private static final Class<?>[] parameterTypes = new Class[]{String.class};
    private static final Log log = LogFactory.getLog(ConfigurationPropertyInstantiator.class);

    @Override
    public <T> T instantiate(Class<T> type, String configuration) {
        T instance = InstantiatorUtil.instantiate(type);
        try {
            Method setter = type.getDeclaredMethod("setConfiguration", parameterTypes);
            setter.setAccessible(true);
            setter.invoke(instance, configuration);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"configuration setter does not exist", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"configuration setter is inaccesible", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("configuration cannot be set to value " + configuration), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"configuration setter threw exception", e.getCause());
        }
        return instance;
    }
}

