/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Node;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypes {
    private static final Log log = LogFactory.getLog(NodeTypes.class);
    static Map<String, Class<? extends Node>> nodeTypes = NodeTypes.initialiseNodeTypes();
    static Map<Class<? extends Node>, String> nodeNames = NodeTypes.createInverseMapping(nodeTypes);

    public static Set<String> getNodeTypes() {
        return nodeTypes.keySet();
    }

    public static Set<Class<? extends Node>> getNodeNames() {
        return nodeNames.keySet();
    }

    public static Class<? extends Node> getNodeType(String name) {
        return nodeTypes.get(name);
    }

    public static String getNodeName(Class<? extends Node> type) {
        return nodeNames.get(type);
    }

    static Map<String, Class<? extends Node>> initialiseNodeTypes() {
        HashMap<String, Class<? extends Node>> types = new HashMap<String, Class<? extends Node>>();
        String resource = JbpmConfiguration.Configs.getString("resource.node.types");
        InputStream actionTypesStream = ClassLoaderUtil.getStream(resource);
        Element nodeTypesElement = XmlUtil.parseXmlInputStream(actionTypesStream).getDocumentElement();
        Iterator<Element> nodeTypeIterator = XmlUtil.elementIterator(nodeTypesElement, "node-type");
        while (nodeTypeIterator.hasNext()) {
            Element nodeTypeElement = nodeTypeIterator.next();
            String elementTag = nodeTypeElement.getAttribute("element");
            String className = nodeTypeElement.getAttribute("class");
            try {
                Class<?> nodeClass = ClassLoaderUtil.classForName(className);
                types.put(elementTag, nodeClass.asSubclass(Node.class));
            }
            catch (Exception e) {
                if ("org.jboss.seam.jbpm.Page".equals(className)) continue;
                log.debug((Object)("node '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded"));
            }
        }
        return types;
    }

    public static <K, V> Map<V, K> createInverseMapping(Map<K, V> map) {
        HashMap<V, K> inverse = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverse.put(entry.getValue(), entry.getKey());
        }
        return inverse;
    }
}

