/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
extends Action {
    private static final long serialVersionUID = 1L;
    protected String expression = null;
    protected Set<VariableAccess> variableAccesses = null;
    private static final Log log = LogFactory.getLog(Script.class);

    @Override
    public void read(Element scriptElement, JpdlXmlReader jpdlReader) {
        if (scriptElement.isTextOnly()) {
            this.expression = scriptElement.getText();
        } else {
            this.variableAccesses = new HashSet<VariableAccess>(jpdlReader.readVariableAccesses(scriptElement));
            this.expression = scriptElement.element("expression").getText();
        }
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        Map<String, Object> outputMap = this.eval(executionContext);
        this.setVariables(outputMap, executionContext);
    }

    public Map<String, Object> eval(Token token) {
        return this.eval(new ExecutionContext(token));
    }

    public Map<String, Object> eval(ExecutionContext executionContext) {
        Map<String, Object> inputMap = this.createInputMap(executionContext);
        Set<String> outputNames = this.getOutputNames();
        return this.eval(inputMap, outputNames);
    }

    public Map<String, Object> createInputMap(ExecutionContext executionContext) {
        HashMap<String, Object> inputMap;
        block3: {
            ContextInstance contextInstance;
            Token token;
            block2: {
                token = executionContext.getToken();
                inputMap = new HashMap<String, Object>();
                inputMap.put("executionContext", executionContext);
                inputMap.put("token", token);
                inputMap.put("node", executionContext.getNode());
                inputMap.put("task", executionContext.getTask());
                inputMap.put("taskInstance", executionContext.getTaskInstance());
                contextInstance = executionContext.getContextInstance();
                if (this.hasReadableVariable()) break block2;
                Map<String, Object> variables = contextInstance.getVariables(token);
                if (variables == null) break block3;
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    String variableName = entry.getKey();
                    Object variableValue = entry.getValue();
                    inputMap.put(variableName, variableValue);
                }
                break block3;
            }
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                String mappedName = variableAccess.getMappedName();
                Object variableValue = contextInstance.getVariable(variableName, token);
                inputMap.put(mappedName, variableValue);
            }
        }
        return inputMap;
    }

    public Map<String, Object> eval(Map<String, Object> inputMap, Set<String> outputNames) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            log.debug((Object)("script input: " + inputMap));
            Interpreter interpreter = new Interpreter();
            for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
                String inputName = entry.getKey();
                Object inputValue = entry.getValue();
                interpreter.set(inputName, inputValue);
            }
            interpreter.eval(this.expression);
            for (String outputName : outputNames) {
                Object outputValue = interpreter.get(outputName);
                outputMap.put(outputName, outputValue);
            }
            log.debug((Object)("script output: " + outputMap));
        }
        catch (ParseException e) {
            throw new DelegationException("parse error occurred", e);
        }
        catch (TargetError e) {
            throw new DelegationException("script threw exception", e.getTarget());
        }
        catch (EvalError e) {
            log.warn((Object)"exception during evaluation of script expression", (Throwable)e);
            throw new DelegationException("script evaluation failed", e);
        }
        return outputMap;
    }

    public void addVariableAccess(VariableAccess variableAccess) {
        if (this.variableAccesses == null) {
            this.variableAccesses = new HashSet<VariableAccess>();
        }
        this.variableAccesses.add(variableAccess);
    }

    Set<String> getOutputNames() {
        HashSet<String> outputNames = new HashSet<String>();
        if (this.variableAccesses != null) {
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isWritable()) continue;
                outputNames.add(variableAccess.getMappedName());
            }
        }
        return outputNames;
    }

    boolean hasReadableVariable() {
        if (this.variableAccesses == null) {
            return false;
        }
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isReadable()) continue;
            return true;
        }
        return false;
    }

    void setVariables(Map<String, Object> outputMap, ExecutionContext executionContext) {
        if (outputMap != null && !outputMap.isEmpty() && executionContext != null) {
            Map<String, String> variableNames = this.getVariableNames();
            ContextInstance contextInstance = executionContext.getContextInstance();
            Token token = executionContext.getToken();
            for (Map.Entry<String, String> entry : variableNames.entrySet()) {
                String mappedName = entry.getKey();
                String variableName = entry.getValue();
                contextInstance.setVariable(variableName, outputMap.get(mappedName), token);
            }
        }
    }

    Map<String, String> getVariableNames() {
        HashMap<String, String> variableNames = new HashMap<String, String>();
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isWritable()) continue;
            variableNames.put(variableAccess.getMappedName(), variableAccess.getVariableName());
        }
        return variableNames;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Set<VariableAccess> getVariableAccesses() {
        return this.variableAccesses;
    }

    public void setVariableAccesses(Set<VariableAccess> variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

