/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.log.VariableDeleteLog;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableContainer
implements Serializable {
    private static final long serialVersionUID = 520258491083406913L;
    protected Map<String, VariableInstance> variableInstances = null;
    private static Log log = LogFactory.getLog(VariableContainer.class);

    protected abstract VariableContainer getParentVariableContainer();

    public abstract Token getToken();

    public Object getVariable(String name) {
        Object value = null;
        if (this.hasVariableLocally(name)) {
            value = this.getVariableLocally(name);
        } else {
            VariableContainer parent = this.getParentVariableContainer();
            if (parent != null) {
                value = parent.getVariable(name);
            }
        }
        return value;
    }

    public void setVariable(String name, Object value) {
        VariableContainer parent = this.getParentVariableContainer();
        if (this.hasVariableLocally(name) || parent == null) {
            this.setVariableLocally(name, value);
        } else {
            parent.setVariable(name, value);
        }
    }

    public boolean hasVariable(String name) {
        boolean hasVariable = false;
        if (this.hasVariableLocally(name)) {
            hasVariable = true;
        } else {
            VariableContainer parent = this.getParentVariableContainer();
            if (parent != null) {
                hasVariable = parent.hasVariable(name);
            }
        }
        return hasVariable;
    }

    public void deleteVariable(String name) {
        if (name == null) {
            throw new JbpmException("name is null");
        }
        if (this.hasVariableLocally(name)) {
            this.deleteVariableLocally(name);
        }
    }

    public void addVariables(Map<String, Object> variables) {
        this.setVariables(variables);
    }

    public void setVariables(Map<String, Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, Object> getVariables() {
        Map<String, Object> variables = this.getVariablesLocally();
        VariableContainer parent = this.getParentVariableContainer();
        if (parent != null) {
            Map<String, Object> parentVariables = parent.getVariablesLocally();
            parentVariables.putAll(variables);
            variables = parentVariables;
        }
        return variables;
    }

    public Map<String, Object> getVariablesLocally() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.variableInstances != null) {
            for (Map.Entry<String, VariableInstance> entry : this.variableInstances.entrySet()) {
                String name = entry.getKey();
                VariableInstance variableInstance = entry.getValue();
                if (variables.containsKey(name)) continue;
                variables.put(name, variableInstance.getValue());
            }
        }
        return variables;
    }

    public boolean hasVariableLocally(String name) {
        return this.variableInstances != null && this.variableInstances.containsKey(name);
    }

    public Object getVariableLocally(String name) {
        Object value = null;
        if (this.hasVariableLocally(name)) {
            value = this.getVariableInstance(name).getValue();
        }
        return value;
    }

    public void deleteVariableLocally(String name) {
        this.deleteVariableInstance(name);
    }

    public void setVariableLocally(String name, Object value) {
        if (name == null) {
            throw new JbpmException("name is null");
        }
        VariableInstance variableInstance = this.getVariableInstance(name);
        if (variableInstance != null && !variableInstance.supports(value)) {
            log.debug((Object)("variable type change. deleting '" + name + "' from '" + this + "'"));
            this.deleteVariableInstance(name);
            variableInstance = null;
        }
        if (variableInstance == null) {
            log.debug((Object)("create variable '" + name + "' in '" + this + "' with value '" + value + "'"));
            variableInstance = VariableInstance.create(this.getToken(), name, value);
            this.addVariableInstance(variableInstance);
        } else {
            log.debug((Object)("update variable '" + name + "' in '" + this + "' to value '" + value + "'"));
            variableInstance.setValue(value);
        }
    }

    public VariableInstance getVariableInstance(String name) {
        return this.variableInstances != null ? this.variableInstances.get(name) : null;
    }

    public Map<String, VariableInstance> getVariableInstances() {
        return this.variableInstances;
    }

    public void addVariableInstance(VariableInstance variableInstance) {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstance>();
        }
        this.variableInstances.put(variableInstance.getName(), variableInstance);
        this.addUpdatedVariableContainer();
    }

    public void deleteVariableInstance(String name) {
        VariableInstance variableInstance;
        if (this.variableInstances != null && (variableInstance = this.variableInstances.remove(name)) != null) {
            this.getToken().addLog(new VariableDeleteLog(variableInstance));
            variableInstance.removeReferences();
        }
    }

    void addUpdatedVariableContainer() {
        ContextInstance contextInstance = this.getContextInstance();
        if (contextInstance != null) {
            if (contextInstance.updatedVariableContainers == null) {
                contextInstance.updatedVariableContainers = new ArrayList<VariableContainer>();
            }
            contextInstance.updatedVariableContainers.add(this);
        }
    }

    public ContextInstance getContextInstance() {
        Token token = this.getToken();
        ProcessInstance processInstance = token != null ? token.getProcessInstance() : null;
        return processInstance != null ? processInstance.getContextInstance() : null;
    }

    public static Collection<VariableContainer> getUpdatedVariableContainers(ProcessInstance processInstance) {
        return processInstance.getContextInstance().updatedVariableContainers;
    }
}

