/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmType {
    static Map<ObjectFactory, List<JbpmType>> jbpmTypesCache = new HashMap<ObjectFactory, List<JbpmType>>();
    final JbpmTypeMatcher jbpmTypeMatcher;
    final Converter converter;
    final Class<? extends VariableInstance> variableInstanceClass;

    public JbpmType(JbpmTypeMatcher jbpmTypeMatcher, Converter converter, Class<? extends VariableInstance> variableInstanceClass) {
        this.jbpmTypeMatcher = jbpmTypeMatcher;
        this.converter = converter;
        this.variableInstanceClass = variableInstanceClass;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public boolean matches(Object value) {
        return this.jbpmTypeMatcher.matches(value);
    }

    public VariableInstance newVariableInstance() {
        VariableInstance variableInstance = null;
        try {
            variableInstance = this.variableInstanceClass.newInstance();
            variableInstance.converter = this.converter;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't instantiate variable instance class '" + this.variableInstanceClass.getName() + "'");
        }
        return variableInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JbpmType> getJbpmTypes() {
        List<JbpmType> jbpmTypes = null;
        ObjectFactory objectFactory = JbpmConfiguration.Configs.getObjectFactory();
        Map<ObjectFactory, List<JbpmType>> map = jbpmTypesCache;
        synchronized (map) {
            jbpmTypes = jbpmTypesCache.get(objectFactory);
            if (jbpmTypes == null) {
                jbpmTypes = objectFactory.hasObject("jbpm.types") ? CollectionUtil.checkList((List)objectFactory.createObject("jbpm.types"), JbpmType.class) : JbpmType.getDefaultJbpmTypes();
                jbpmTypesCache.put(objectFactory, jbpmTypes);
            }
        }
        return jbpmTypes;
    }

    private static List<JbpmType> getDefaultJbpmTypes() {
        String resource = JbpmConfiguration.Configs.getString("resource.varmapping");
        InputStream is = ClassLoaderUtil.getStream(resource);
        ObjectFactoryImpl objectFactory = ObjectFactoryParser.parseInputStream(is);
        return CollectionUtil.checkList((List)objectFactory.createObject("jbpm.types"), JbpmType.class);
    }
}

