/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractCancelCommand;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.util.Clock;

public class CancelProcessInstanceCommand
extends AbstractCancelCommand {
    private static final long serialVersionUID = 7145293049356621597L;
    private long processInstanceId;

    public CancelProcessInstanceCommand() {
    }

    public CancelProcessInstanceCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        this.cancelProcess(this.processInstanceId);
        this.jbpmContext = null;
        return null;
    }

    protected void cancelProcess(long processInstanceIdToCancel) {
        ProcessInstance pi = this.jbpmContext.getProcessInstanceForUpdate(processInstanceIdToCancel);
        log.info((Object)("cancel process instance " + pi.getId()));
        pi.getContextInstance().createVariable("canceled", Clock.getCurrentTime());
        try {
            this.cancelToken(pi.getRootToken());
            pi.end();
            log.info((Object)"finished process cancellation");
        }
        catch (RuntimeException ex) {
            log.error((Object)"problems while cancel process", (Throwable)ex);
            throw ex;
        }
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getProcessId() {
        return this.processInstanceId;
    }

    public void setProcessId(long processId) {
        this.processInstanceId = processId;
    }

    public String getAdditionalToStringInformation() {
        return "processInstanceId=" + this.processInstanceId;
    }

    public CancelProcessInstanceCommand processInstanceId(long processInstanceId) {
        this.setProcessInstanceId(processInstanceId);
        return this;
    }
}

