/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IoUtil {
    private static final int BUFFERSIZE = 4096;

    private IoUtil() {
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IoUtil.transfer(inputStream, outputStream);
        return outputStream.toByteArray();
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        if (in == null || out == null) {
            throw new IllegalArgumentException("In/OutStream cannot be null");
        }
        int total = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
        }
        return total;
    }
}

