/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.security.authentication;

import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.security.AuthenticationService;
import org.jbpm.util.ClassLoaderUtil;

public class SubjectAuthenticationService
implements AuthenticationService {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SubjectAuthenticationService.class);
    private Class principalClass;
    private boolean allowActorIdOverwrite;
    private String actorId;

    public SubjectAuthenticationService(String principalClassName, Boolean allowActorIdOverwrite) {
        if (principalClassName != null) {
            this.initPrincipalClass(principalClassName);
        } else {
            this.initPrincipalClass(JbpmConfiguration.Configs.getString("jbpm.authenticator.principal.classname"));
        }
        this.allowActorIdOverwrite = allowActorIdOverwrite != null ? allowActorIdOverwrite : JbpmConfiguration.Configs.getBoolean("jbpm.authenticator.principal.allow.overwrite");
    }

    public SubjectAuthenticationService() {
        this.initPrincipalClass(JbpmConfiguration.Configs.getString("jbpm.authenticator.principal.classname"));
        this.allowActorIdOverwrite = JbpmConfiguration.Configs.getBoolean("jbpm.authenticator.principal.allow.overwrite");
    }

    protected void initPrincipalClass(String principalClassName) {
        this.principalClass = ClassLoaderUtil.classForName(principalClassName);
    }

    @Override
    public String getActorId() {
        if (this.actorId == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                log.info((Object)"no javax.security.auth.Subject exists! Cannot set jbpm actorId");
                return null;
            }
            Set principals = subject.getPrincipals(this.principalClass);
            if (principals != null && !principals.isEmpty()) {
                Principal principal = (Principal)principals.iterator().next();
                this.actorId = principal.getName();
            }
        }
        return this.actorId;
    }

    @Override
    public void setActorId(String actorId) {
        if (this.allowActorIdOverwrite && actorId != null) {
            this.actorId = actorId;
        }
    }

    @Override
    public void close() {
    }
}

