/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.persistence.jta.JtaDbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private UserTransaction transaction;
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(JtaDbPersistenceService.class);

    public JtaDbPersistenceService(JtaDbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isTransactionActive()) {
            this.beginTransaction();
        }
    }

    @Override
    public boolean isTransactionActive() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactory);
    }

    @Override
    protected boolean isTransactionManagedExternally() {
        return this.transaction == null;
    }

    @Override
    protected boolean isTransactionRollbackOnly() {
        return super.isTransactionRollbackOnly() || JTAHelper.isMarkedForRollback((int)this.getTransactionStatus());
    }

    @Override
    public void beginTransaction() {
        try {
            log.debug((Object)("beginning " + this.transaction));
            JtaDbPersistenceServiceFactory jtaFactory = (JtaDbPersistenceServiceFactory)this.persistenceServiceFactory;
            this.transaction = jtaFactory.getUserTransaction();
            this.transaction.begin();
        }
        catch (Exception e) {
            throw new JbpmException("transaction begin failed", e);
        }
    }

    private int getTransactionStatus() {
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            log.error((Object)"could not get transaction status", (Throwable)e);
            return 5;
        }
    }

    @Override
    protected Exception commit() {
        log.debug((Object)("committing " + this.transaction));
        try {
            this.transaction.commit();
            return null;
        }
        catch (Exception e) {
            if (JtaDbPersistenceService.isStaleStateException(e)) {
                log.debug((Object)("optimistic locking failed, could not commit " + this.transaction));
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not commit " + this.transaction), (Throwable)e);
            } else {
                log.debug((Object)"transaction commit failed", (Throwable)e);
            }
            return e;
        }
    }

    @Override
    protected Exception rollback() {
        log.debug((Object)("rolling back " + this.transaction));
        try {
            this.transaction.rollback();
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"transaction rollback failed", (Throwable)e);
            return e;
        }
    }

    public boolean isJtaTxCreated() {
        return !this.isTransactionManagedExternally();
    }
}

