/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.db;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.msg.MessageService;

public class DbMessageService
implements MessageService {
    private static final long serialVersionUID = 1L;
    JobSession jobSession = null;
    JobExecutor jobExecutor = null;
    boolean hasProducedJobs = false;
    private static Log log = LogFactory.getLog(DbMessageService.class);

    public DbMessageService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the DbMessageService requires a current JbpmContext");
        }
        this.jobSession = jbpmContext.getJobSession();
        this.jobExecutor = jbpmContext.getJbpmConfiguration().getJobExecutor();
    }

    @Override
    public void send(Job job) {
        this.jobSession.saveJob(job);
        log.debug((Object)("saved " + job));
        this.hasProducedJobs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.hasProducedJobs && this.jobExecutor != null) {
            log.debug((Object)"messages were produced, job executor will be signalled");
            JobExecutor jobExecutor = this.jobExecutor;
            synchronized (jobExecutor) {
                this.jobExecutor.notify();
            }
        }
    }
}

