/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.mail;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.mail.AddressResolver;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Mail
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    String template = null;
    String actors = null;
    String to = null;
    String bcc = null;
    String bccActors = null;
    String subject = null;
    String text = null;
    ExecutionContext executionContext = null;
    static Map templates = null;
    static Map templateVariables = null;
    private static Log log = LogFactory.getLog(Mail.class);

    public Mail() {
    }

    public Mail(String template, String actors, String to, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.subject = subject;
        this.text = text;
    }

    public Mail(String template, String actors, String to, String bccActors, String bcc, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.bccActors = bccActors;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.send();
    }

    public List getRecipients() {
        String evaluatedActors;
        List tokenizedActors;
        ArrayList recipients = new ArrayList();
        if (this.actors != null && (tokenizedActors = this.tokenize(evaluatedActors = this.evaluate(this.actors))) != null) {
            recipients.addAll(this.resolveAddresses(tokenizedActors));
        }
        if (this.to != null) {
            String resolvedTo = this.evaluate(this.to);
            recipients.addAll(this.tokenize(resolvedTo));
        }
        return recipients;
    }

    public List getBccRecipients() {
        String evaluatedActors;
        List tokenizedActors;
        ArrayList recipients = new ArrayList();
        if (this.bccActors != null && (tokenizedActors = this.tokenize(evaluatedActors = this.evaluate(this.bccActors))) != null) {
            recipients.addAll(this.resolveAddresses(tokenizedActors));
        }
        if (this.bcc != null) {
            String resolvedTo = this.evaluate(this.bcc);
            recipients.addAll(this.tokenize(resolvedTo));
        }
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.bcc.address")) {
            recipients.addAll(this.tokenize(JbpmConfiguration.Configs.getString("jbpm.mail.bcc.address")));
        }
        return recipients;
    }

    public String getSubject() {
        if (this.subject == null) {
            return null;
        }
        return this.evaluate(this.subject);
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return this.evaluate(this.text);
    }

    public String getFromAddress() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.from.address")) {
            return JbpmConfiguration.Configs.getString("jbpm.mail.from.address");
        }
        return "jbpm@noreply";
    }

    public void send() {
        if (this.template != null) {
            Properties properties = this.getMailTemplateProperties(this.template);
            if (this.actors == null) {
                this.actors = properties.getProperty("actors");
            }
            if (this.to == null) {
                this.to = properties.getProperty("to");
            }
            if (this.subject == null) {
                this.subject = properties.getProperty("subject");
            }
            if (this.text == null) {
                this.text = properties.getProperty("text");
            }
            if (this.bcc == null) {
                this.bcc = properties.getProperty("bcc");
            }
            if (this.bccActors == null) {
                this.bccActors = properties.getProperty("bccActors");
            }
        }
        Mail.send(this.getMailServerProperties(), this.getFromAddress(), this.getRecipients(), this.getBccRecipients(), this.getSubject(), this.getText());
    }

    public static void send(Properties mailServerProperties, String fromAddress, List recipients, String subject, String text) {
        Mail.send(mailServerProperties, fromAddress, recipients, null, subject, text);
    }

    public static void send(Properties mailServerProperties, String fromAddress, List recipients, List bccRecipients, String subject, String text) {
        if ((recipients == null || recipients.isEmpty()) && (bccRecipients == null || bccRecipients.isEmpty())) {
            log.debug((Object)"skipping mail because there are no recipients");
            return;
        }
        try {
            int retries = 5;
            while (retries > 0) {
                --retries;
                try {
                    Mail.sendMailInternal(mailServerProperties, fromAddress, recipients, bccRecipients, subject, text);
                    break;
                }
                catch (MessagingException msgex) {
                    if (retries == 0) {
                        throw msgex;
                    }
                    System.out.println("Cannot send mail, now retrying: " + (Object)((Object)msgex));
                    log.error((Object)("Cannot send mail, now retrying: " + (Object)((Object)msgex)));
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            throw new JbpmException("Cannot send email", e);
        }
    }

    private static void sendMailInternal(Properties mailServerProperties, String fromAddress, List recipients, List bccRecipients, String subject, String text) throws Exception {
        InternetAddress recipient;
        log.debug((Object)("sending email to '" + recipients + "' " + (bccRecipients != null ? "and in bcc to '" + bccRecipients + "' " : "") + "about '" + subject + "'"));
        Session session = Session.getDefaultInstance((Properties)mailServerProperties, null);
        MimeMessage message = new MimeMessage(session);
        if (fromAddress != null) {
            message.setFrom((Address)new InternetAddress(fromAddress));
        }
        Iterator iter = recipients.iterator();
        while (iter.hasNext()) {
            recipient = new InternetAddress((String)iter.next());
            message.addRecipient(Message.RecipientType.TO, (Address)recipient);
        }
        if (bccRecipients != null) {
            iter = bccRecipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.BCC, (Address)recipient);
            }
        }
        if (subject != null) {
            message.setSubject(subject);
        }
        if (text != null) {
            message.setText(text);
        }
        message.setSentDate(new Date());
        Transport.send((Message)message);
    }

    protected List tokenize(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, ";:");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    protected Collection resolveAddresses(List actorIds) {
        ArrayList<String> emailAddresses = new ArrayList<String>();
        for (String actorId : actorIds) {
            AddressResolver addressResolver = (AddressResolver)JbpmConfiguration.Configs.getObject("jbpm.mail.address.resolver");
            Object resolvedAddresses = addressResolver.resolveAddress(actorId);
            if (resolvedAddresses == null) continue;
            if (resolvedAddresses instanceof String) {
                emailAddresses.add((String)resolvedAddresses);
                continue;
            }
            if (resolvedAddresses instanceof Collection) {
                emailAddresses.addAll((Collection)resolvedAddresses);
                continue;
            }
            if (resolvedAddresses instanceof String[]) {
                emailAddresses.addAll((Collection)Arrays.asList((String[])resolvedAddresses));
                continue;
            }
            throw new JbpmException("Address resolver '" + addressResolver + "' returned '" + resolvedAddresses.getClass().getName() + "' instead of a String, Collection or String-array: " + resolvedAddresses);
        }
        return emailAddresses;
    }

    Properties getMailServerProperties() {
        Properties mailServerProperties = new Properties();
        if (JbpmConfiguration.Configs.hasObject("resource.mail.properties")) {
            String mailServerPropertiesResource = JbpmConfiguration.Configs.getString("resource.mail.properties");
            try {
                InputStream mailServerStream = ClassLoaderUtil.getStream(mailServerPropertiesResource);
                mailServerProperties.load(mailServerStream);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't get configuration properties for jbpm mail server from resource '" + mailServerPropertiesResource + "'", e);
            }
        } else if (JbpmConfiguration.Configs.hasObject("jbpm.mail.smtp.host")) {
            String smtpServer = JbpmConfiguration.Configs.getString("jbpm.mail.smtp.host");
            mailServerProperties.put("mail.smtp.host", smtpServer);
        } else {
            log.error((Object)"couldn't get mail properties");
        }
        return mailServerProperties;
    }

    synchronized Properties getMailTemplateProperties(String templateName) {
        if (templates == null) {
            templates = new HashMap();
            String mailTemplatesResource = JbpmConfiguration.Configs.getString("resource.mail.templates");
            Element mailTemplatesElement = XmlUtil.parseXmlResource(mailTemplatesResource, false).getDocumentElement();
            List<Element> mailTemplateElements = XmlUtil.elements(mailTemplatesElement, "mail-template");
            for (Element mailTemplateElement : mailTemplateElements) {
                Properties templateProperties = new Properties();
                this.addTemplateProperty(mailTemplateElement, "actors", templateProperties);
                this.addTemplateProperty(mailTemplateElement, "to", templateProperties);
                this.addTemplateProperty(mailTemplateElement, "subject", templateProperties);
                this.addTemplateProperty(mailTemplateElement, "text", templateProperties);
                this.addTemplateProperty(mailTemplateElement, "bcc", templateProperties);
                this.addTemplateProperty(mailTemplateElement, "bccActors", templateProperties);
                templates.put(mailTemplateElement.getAttribute("name"), templateProperties);
            }
            templateVariables = new HashMap();
            List<Element> variableElements = XmlUtil.elements(mailTemplatesElement, "variable");
            for (Element variableElement : variableElements) {
                templateVariables.put(variableElement.getAttribute("name"), variableElement.getAttribute("value"));
            }
        }
        return (Properties)templates.get(templateName);
    }

    void addTemplateProperty(Element mailTemplateElement, String property, Properties templateProperties) {
        Element element = XmlUtil.element(mailTemplateElement, property);
        if (element != null) {
            templateProperties.put(property, XmlUtil.getContentText(element));
        }
    }

    String evaluate(String expression) {
        if (expression == null) {
            return null;
        }
        VariableResolver variableResolver = JbpmExpressionEvaluator.getUsedVariableResolver();
        if (variableResolver != null) {
            variableResolver = new MailVariableResolver(templateVariables, variableResolver);
        }
        return (String)JbpmExpressionEvaluator.evaluate(expression, this.executionContext, variableResolver, JbpmExpressionEvaluator.getUsedFunctionMapper());
    }

    class MailVariableResolver
    implements VariableResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        Map templateVariables = null;
        VariableResolver variableResolver = null;

        public MailVariableResolver(Map templateVariables, VariableResolver variableResolver) {
            this.templateVariables = templateVariables;
            this.variableResolver = variableResolver;
        }

        @Override
        public Object resolveVariable(String pName) throws ELException {
            if (this.templateVariables != null && this.templateVariables.containsKey(pName)) {
                return this.templateVariables.get(pName);
            }
            return this.variableResolver.resolveVariable(pName);
        }
    }
}

