/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.util.ClassLoaderUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JpdlParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    static SAXParserFactory saxParserFactory = JpdlParser.createSaxParserFactory();
    private static Set schemaResources = JpdlParser.getDefaultSchemaResources();
    private static Object schemaSource;
    private static final Log log;

    static {
        log = LogFactory.getLog(JpdlParser.class);
    }

    public static Document parse(InputSource inputSource, ProblemListener problemListener) throws Exception {
        Document document = null;
        SAXReader saxReader = JpdlParser.createSaxReader(problemListener);
        document = saxReader.read(inputSource);
        return document;
    }

    public static SAXReader createSaxReader(ProblemListener problemListener) throws Exception {
        XMLReader xmlReader = JpdlParser.createXmlReader();
        SAXReader saxReader = new SAXReader(xmlReader);
        saxReader.setErrorHandler((ErrorHandler)new JpdlErrorHandler(problemListener));
        return saxReader;
    }

    public static XMLReader createXmlReader() throws Exception {
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        try {
            saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set schema language property", (Throwable)e);
        }
        try {
            saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", JpdlParser.getSchemaSource());
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set schema source property", (Throwable)e);
        }
        try {
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException e) {
            log.warn((Object)"couldn't set dynamic validation feature", (Throwable)e);
        }
        return xmlReader;
    }

    private static Object getSchemaSource() {
        if (schemaSource == null) {
            ClassLoader classLoader = ClassLoaderUtil.getClassLoader();
            ArrayList<String> schemaLocations = new ArrayList<String>(schemaResources.size());
            for (String schemaResource : schemaResources) {
                URL schemaURL = classLoader.getResource(schemaResource);
                if (schemaURL == null) continue;
                String schemaLocation = schemaURL.toString();
                log.debug((Object)("schema resource found: " + schemaResource));
                schemaLocations.add(schemaLocation);
            }
            schemaSource = schemaLocations.toArray(new String[schemaLocations.size()]);
        }
        return schemaSource;
    }

    public static void addSchemaResource(String resource) {
        schemaResources.add(resource);
        schemaSource = null;
    }

    private static Set getDefaultSchemaResources() {
        HashSet<String> schemaResources = new HashSet<String>();
        schemaResources.add("org/jbpm/jpdl/xml/jpdl-3.0.xsd");
        schemaResources.add("org/jbpm/jpdl/xml/jpdl-3.1.xsd");
        schemaResources.add("org/jbpm/jpdl/xml/jpdl-3.2.xsd");
        schemaResources.add("org/jbpm/jpdl/xml/jpdl-3.3.xsd");
        schemaResources.add("org/jboss/seam/pageflow-2.0.xsd");
        return schemaResources;
    }

    private static SAXParserFactory createSaxParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory;
    }

    static class JpdlErrorHandler
    implements ErrorHandler,
    Serializable {
        private ProblemListener problemListener = null;
        private static final long serialVersionUID = 1L;

        JpdlErrorHandler(ProblemListener problemListener) {
            this.problemListener = problemListener;
        }

        @Override
        public void warning(SAXParseException pe) {
            this.addProblem(3, pe);
        }

        @Override
        public void error(SAXParseException pe) {
            this.addProblem(2, pe);
        }

        @Override
        public void fatalError(SAXParseException pe) {
            this.addProblem(1, pe);
        }

        private void addProblem(int level, SAXParseException pe) {
            Problem problem = new Problem(level, pe.getMessage(), pe);
            problem.setResource(pe.getSystemId());
            int line = pe.getLineNumber();
            if (line != -1) {
                problem.setLine(new Integer(line));
            }
            this.problemListener.addProblem(problem);
        }
    }
}

