/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import java.util.List;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.BinaryOperator;
import org.jbpm.jpdl.el.impl.Coercions;
import org.jbpm.jpdl.el.impl.Expression;
import org.jbpm.jpdl.el.impl.Logger;

public class BinaryOperatorExpression
extends Expression {
    Expression mExpression;
    List mOperators;
    List mExpressions;

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression pExpression) {
        this.mExpression = pExpression;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List pOperators) {
        this.mOperators = pOperators;
    }

    public List getExpressions() {
        return this.mExpressions;
    }

    public void setExpressions(List pExpressions) {
        this.mExpressions = pExpressions;
    }

    public BinaryOperatorExpression(Expression pExpression, List pOperators, List pExpressions) {
        this.mExpression = pExpression;
        this.mOperators = pOperators;
        this.mExpressions = pExpressions;
    }

    @Override
    public String getExpressionString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        buf.append(this.mExpression.getExpressionString());
        int i = 0;
        while (i < this.mOperators.size()) {
            BinaryOperator operator = (BinaryOperator)this.mOperators.get(i);
            Expression expression = (Expression)this.mExpressions.get(i);
            buf.append(" ");
            buf.append(operator.getOperatorSymbol());
            buf.append(" ");
            buf.append(expression.getExpressionString());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Object evaluate(VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        Object value = this.mExpression.evaluate(pResolver, functions, pLogger);
        int i = 0;
        while (i < this.mOperators.size()) {
            BinaryOperator operator = (BinaryOperator)this.mOperators.get(i);
            if (operator.shouldCoerceToBoolean()) {
                value = Coercions.coerceToBoolean(value, pLogger);
            }
            if (operator.shouldEvaluate(value)) {
                Expression expression = (Expression)this.mExpressions.get(i);
                Object nextValue = expression.evaluate(pResolver, functions, pLogger);
                value = operator.apply(value, nextValue, pLogger);
            }
            ++i;
        }
        return value;
    }
}

