/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class LockMonitorThread
extends Thread {
    JbpmConfiguration jbpmConfiguration;
    int lockMonitorInterval;
    int maxLockTime;
    int lockBufferTime;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog(LockMonitorThread.class);

    public LockMonitorThread(JobExecutor jobExecutor) {
        this.jbpmConfiguration = jobExecutor.getJbpmConfiguration();
        this.lockMonitorInterval = jobExecutor.getLockMonitorInterval();
        this.maxLockTime = jobExecutor.getMaxLockTime();
        this.lockBufferTime = jobExecutor.getLockBufferTime();
    }

    @Deprecated
    public LockMonitorThread(JbpmConfiguration jbpmConfiguration, int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.jbpmConfiguration = jbpmConfiguration;
        this.lockMonitorInterval = lockMonitorInterval;
        this.maxLockTime = maxLockTime;
        this.lockBufferTime = lockBufferTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                while (true) {
                    if (!this.isActive) {
                        return;
                    }
                    try {
                        this.unlockOverdueJobs();
                        if (!this.isActive || this.lockMonitorInterval <= 0) continue;
                        LockMonitorThread.sleep(this.lockMonitorInterval);
                    }
                    catch (InterruptedException e) {
                        log.info((Object)("lock monitor thread '" + this.getName() + "' got interrupted"));
                    }
                    catch (Exception e) {
                        log.error((Object)("exception in lock monitor thread. waiting " + this.lockMonitorInterval + " milliseconds"), (Throwable)e);
                        try {
                            LockMonitorThread.sleep(this.lockMonitorInterval);
                        }
                        catch (InterruptedException e2) {
                            log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"exception in lock monitor thread", (Throwable)e);
                log.info((Object)(String.valueOf(this.getName()) + " leaves cyberspace"));
                return;
            }
        }
        finally {
            log.info((Object)(String.valueOf(this.getName()) + " leaves cyberspace"));
        }
    }

    protected void unlockOverdueJobs() {
        List<Job> overdueJobs = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            Date threshold = new Date(System.currentTimeMillis() - (long)this.maxLockTime - (long)this.lockBufferTime);
            JobSession jobSession = jbpmContext.getJobSession();
            overdueJobs = jobSession.findJobsWithOverdueLockTime(threshold);
            for (Job job : overdueJobs) {
                log.debug((Object)("unlocking " + job + " owned by thread " + job.getLockOwner()));
                job.setLockOwner(null);
                job.setLockTime(null);
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if (DbPersistenceService.isStaleStateException(e)) {
                    log.debug((Object)("optimistic locking failed, could not unlock overdue jobs: " + overdueJobs));
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)"problem unlocking overdue jobs: optimistic locking failed", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

