/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread {
    final JobExecutor jobExecutor;
    final JbpmConfiguration jbpmConfiguration;
    final int idleInterval;
    final int maxIdleInterval;
    final long maxLockTime;
    int currentIdleInterval;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog(JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jobExecutor.getJbpmConfiguration();
        this.idleInterval = jobExecutor.getIdleInterval();
        this.maxIdleInterval = jobExecutor.getMaxIdleInterval();
        this.maxLockTime = jobExecutor.getMaxLockTime();
    }

    @Deprecated
    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jbpmConfiguration;
        this.idleInterval = idleInterval;
        this.maxIdleInterval = maxIdleInterval;
        this.maxLockTime = maxLockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.currentIdleInterval = this.idleInterval;
        while (this.isActive) {
            try {
                long waitPeriod;
                Collection<Job> acquiredJobs = this.acquireJobs();
                if (!acquiredJobs.isEmpty()) {
                    for (Job job : acquiredJobs) {
                        this.executeJob(job);
                        if (this.isActive) {
                            continue;
                        }
                        break;
                    }
                } else if (this.isActive && (waitPeriod = this.getWaitPeriod()) > 0L) {
                    JobExecutor jobExecutor = this.jobExecutor;
                    synchronized (jobExecutor) {
                        this.jobExecutor.wait(waitPeriod);
                    }
                }
                this.currentIdleInterval = this.idleInterval;
            }
            catch (InterruptedException e) {
                log.info((Object)(String.valueOf(this.isActive ? "active" : "inactive") + " job executor thread '" + this.getName() + "' got interrupted"));
            }
            catch (Exception e) {
                log.error((Object)("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds"), (Throwable)e);
                try {
                    JobExecutor waitPeriod = this.jobExecutor;
                    synchronized (waitPeriod) {
                        this.jobExecutor.wait(this.currentIdleInterval);
                    }
                }
                catch (InterruptedException e2) {
                    log.debug((Object)"delay after exception got interrupted", (Throwable)e2);
                }
                this.currentIdleInterval *= 2;
                if (this.currentIdleInterval <= this.maxIdleInterval && this.currentIdleInterval >= 0) continue;
                this.currentIdleInterval = this.maxIdleInterval;
            }
        }
        log.info((Object)(String.valueOf(this.getName()) + " leaves cyberspace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Job> acquireJobs() {
        Collection<Job> acquiredJobs = Collections.emptyList();
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            try {
                log.debug((Object)"querying for acquirable job...");
                String lockOwner = this.getName();
                JobSession jobSession = jbpmContext.getJobSession();
                Job job = jobSession.getFirstAcquirableJob(lockOwner);
                if (job != null) {
                    if (job.isExclusive()) {
                        ProcessInstance processInstance = job.getProcessInstance();
                        log.debug((Object)("loaded exclusive " + job + ", finding exclusive jobs for " + processInstance));
                        acquiredJobs = jobSession.findExclusiveJobs(lockOwner, processInstance);
                        log.debug((Object)("trying to obtain locks on " + acquiredJobs + " for " + processInstance));
                    } else {
                        acquiredJobs = Collections.singletonList(job);
                        log.debug((Object)("trying to obtain lock on " + job));
                    }
                    Date lockTime = new Date();
                    for (Job acquiredJob : acquiredJobs) {
                        acquiredJob.setLockOwner(lockOwner);
                        acquiredJob.setLockTime(lockTime);
                    }
                } else {
                    log.debug((Object)"no acquirable jobs");
                }
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        jbpmContext.close();
                        log.debug((Object)("obtained lock on jobs: " + acquiredJobs));
                    }
                    catch (JbpmPersistenceException e) {
                        if (DbPersistenceService.isStaleStateException(e)) {
                            log.debug((Object)("optimistic locking failed, could not acquire jobs " + acquiredJobs));
                            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not acquire jobs " + acquiredJobs), (Throwable)e);
                            acquiredJobs = Collections.emptyList();
                            break block16;
                        }
                        throw e;
                    }
                }
                throw throwable;
            }
            try {
                jbpmContext.close();
                log.debug((Object)("obtained lock on jobs: " + acquiredJobs));
            }
            catch (JbpmPersistenceException e) {
                if (DbPersistenceService.isStaleStateException(e)) {
                    log.debug((Object)("optimistic locking failed, could not acquire jobs " + acquiredJobs));
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not acquire jobs " + acquiredJobs), (Throwable)e);
                    acquiredJobs = Collections.emptyList();
                }
                throw e;
            }
        }
        return acquiredJobs;
    }

    protected void executeJob(Job job) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            long totalLockTimeInMillis;
            JobSession jobSession = jbpmContext.getJobSession();
            job = jobSession.loadJob(job.getId());
            log.debug((Object)("executing " + job));
            try {
                if (job.execute(jbpmContext)) {
                    jobSession.deleteJob(job);
                }
            }
            catch (Exception e) {
                log.debug((Object)("exception while executing " + job), (Throwable)e);
                if (!DbPersistenceService.isPersistenceException(e)) {
                    StringWriter memoryWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter(memoryWriter));
                    job.setException(memoryWriter.toString());
                    job.setRetries(job.getRetries() - 1);
                }
                jbpmContext.setRollbackOnly();
            }
            if ((totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime()) > this.maxLockTime) {
                jbpmContext.setRollbackOnly();
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (JbpmPersistenceException e) {
                if (DbPersistenceService.isStaleStateException(e)) {
                    log.debug((Object)("optimistic locking failed, could not complete job " + job));
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not complete job " + job), (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Set<Long> jobIdsToIgnore = this.jobExecutor.getMonitoredJobIds();
            Job job = jobSession.getFirstDueJob(this.getName(), jobIdsToIgnore);
            if (job != null) {
                nextDueDate = job.getDueDate();
                this.jobExecutor.addMonitoredJobId(this.getName(), job.getId());
            }
        }
        catch (Throwable throwable) {
            block9: {
                try {
                    jbpmContext.close();
                }
                catch (JbpmPersistenceException e) {
                    if (DbPersistenceService.isStaleStateException(e)) {
                        log.debug((Object)("optimistic locking failed, could not return next due date: " + nextDueDate));
                        StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not return next due date: " + nextDueDate), (Throwable)e);
                        nextDueDate = null;
                        break block9;
                    }
                    throw e;
                }
            }
            throw throwable;
        }
        try {
            jbpmContext.close();
        }
        catch (JbpmPersistenceException e) {
            if (DbPersistenceService.isStaleStateException(e)) {
                log.debug((Object)("optimistic locking failed, could not return next due date: " + nextDueDate));
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not return next due date: " + nextDueDate), (Throwable)e);
                nextDueDate = null;
            }
            throw e;
        }
        return nextDueDate;
    }

    protected long getWaitPeriod() {
        long interval = this.currentIdleInterval;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTime = System.currentTimeMillis();
            long nextDueTime = nextDueDate.getTime();
            if (nextDueTime < currentTime + (long)this.currentIdleInterval) {
                interval = nextDueTime - currentTime;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

