/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jcr.impl;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.jcr.impl.JcrServiceImpl;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

public abstract class AbstractJcrServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    String username = null;
    String password = null;
    String workspace = null;
    private static Log log = LogFactory.getLog(AbstractJcrServiceFactory.class);

    @Override
    public Service openService() {
        Session session = null;
        try {
            Repository jcrRepository = this.getRepository();
            log.debug((Object)("opening jcr session " + (this.username != null ? this.username : "") + " " + (this.workspace != null ? this.workspace : "")));
            session = this.username == null && this.workspace == null ? jcrRepository.login() : (this.username == null ? jcrRepository.login(this.workspace) : (this.workspace == null ? jcrRepository.login(this.getCredentials()) : jcrRepository.login(this.getCredentials(), this.workspace)));
        }
        catch (Exception e) {
            throw new JbpmException("couldn't open session to JCR repository, userId(" + this.username + "), workspace(" + this.workspace + ")", e);
        }
        return new JcrServiceImpl(session);
    }

    Credentials getCredentials() {
        char[] pwdChars = this.password != null ? this.password.toCharArray() : null;
        SimpleCredentials credentials = new SimpleCredentials(this.username, pwdChars);
        return credentials;
    }

    protected abstract Repository getRepository();

    @Override
    public void close() {
    }
}

