/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.job.ExecuteActionJob;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.signal.EventService;
import org.jbpm.svc.Services;
import org.jbpm.util.EqualsUtil;

public abstract class GraphElement
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected String description = null;
    protected ProcessDefinition processDefinition = null;
    protected Map<String, Event> events = null;
    protected List<ExceptionHandler> exceptionHandlers = null;
    private static final Log log = LogFactory.getLog(GraphElement.class);

    public GraphElement() {
    }

    public GraphElement(String name) {
        this.setName(name);
    }

    public abstract String[] getSupportedEventTypes();

    public Map<String, Event> getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return this.events != null && this.events.size() > 0;
    }

    public Event getEvent(String eventType) {
        Event event = null;
        if (this.events != null) {
            event = this.events.get(eventType);
        }
        return event;
    }

    public boolean hasEvent(String eventType) {
        boolean hasEvent = false;
        if (this.events != null) {
            hasEvent = this.events.containsKey(eventType);
        }
        return hasEvent;
    }

    public Event addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("can't add null event to graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't add an event without type to graph element");
        }
        if (this.events == null) {
            this.events = new HashMap<String, Event>();
        }
        this.events.put(event.getEventType(), event);
        event.graphElement = this;
        return event;
    }

    public Event removeEvent(Event event) {
        Event removedEvent = null;
        if (event == null) {
            throw new IllegalArgumentException("can't remove null event from graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't remove an event without type from graph element");
        }
        if (this.events != null && (removedEvent = this.events.remove(event.getEventType())) != null) {
            event.graphElement = null;
        }
        return removedEvent;
    }

    public List<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't add null exceptionHandler to graph element");
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList<ExceptionHandler>();
        }
        this.exceptionHandlers.add(exceptionHandler);
        exceptionHandler.graphElement = this;
        return exceptionHandler;
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't remove null exceptionHandler from graph element");
        }
        if (this.exceptionHandlers != null && this.exceptionHandlers.remove(exceptionHandler)) {
            exceptionHandler.graphElement = null;
        }
    }

    public void reorderExceptionHandler(int oldIndex, int newIndex) {
        if (this.exceptionHandlers == null || Math.min(oldIndex, newIndex) < 0 || Math.max(oldIndex, newIndex) >= this.exceptionHandlers.size()) {
            throw new IndexOutOfBoundsException("couldn't reorder element from index '" + oldIndex + "' to index '" + newIndex + "' in " + this.exceptionHandlers);
        }
        ExceptionHandler o = this.exceptionHandlers.remove(oldIndex);
        this.exceptionHandlers.add(newIndex, o);
    }

    public void fireEvent(String eventType, ExecutionContext executionContext) {
        log.debug((Object)("event '" + eventType + "' on " + this + " for " + executionContext.getToken()));
        try {
            EventService evService;
            Services services;
            executionContext.setEventSource(this);
            JbpmContext jbpmContext = executionContext.getJbpmContext();
            if (jbpmContext != null && (services = jbpmContext.getServices()) != null && (evService = (EventService)services.getService("event")) != null) {
                evService.fireEvent(eventType, this, executionContext);
            }
            this.fireAndPropagateEvent(eventType, executionContext);
        }
        finally {
            executionContext.setEventSource(null);
        }
    }

    public void fireAndPropagateEvent(String eventType, ExecutionContext executionContext) {
        boolean isPropagated = !this.equals(executionContext.getEventSource());
        Event event = this.getEvent(eventType);
        if (event != null) {
            executionContext.setEvent(event);
            this.executeActions(event.getActions(), executionContext, isPropagated);
        }
        List<Action> runtimeActions = this.getRuntimeActionsForEvent(executionContext, eventType);
        this.executeActions(runtimeActions, executionContext, isPropagated);
        executionContext.setEvent(null);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.fireAndPropagateEvent(eventType, executionContext);
        }
    }

    void executeActions(List<Action> actions, ExecutionContext executionContext, boolean isPropagated) {
        if (actions != null) {
            for (Action action : actions) {
                if (!action.acceptsPropagatedEvents() && isPropagated) continue;
                if (action.isAsync()) {
                    ExecuteActionJob job = this.createAsyncActionExecutionJob(executionContext.getToken(), action);
                    MessageService messageService = (MessageService)Services.getCurrentService("message");
                    messageService.send(job);
                    continue;
                }
                this.executeAction(action, executionContext);
            }
        }
    }

    protected ExecuteActionJob createAsyncActionExecutionJob(Token token, Action action) {
        ExecuteActionJob job = new ExecuteActionJob(token);
        job.setAction(action);
        job.setDueDate(new Date());
        job.setExclusive(action.isAsyncExclusive());
        return job;
    }

    public void executeAction(Action action, ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        ActionLog actionLog = new ActionLog(action);
        token.startCompositeLog(actionLog);
        boolean actionMustBeLocked = executionContext.getEvent() != null && !token.isLocked();
        try {
            try {
                executionContext.setAction(action);
                log.debug((Object)("executing " + action));
                String lockOwnerId = "token[" + token.getId() + "]";
                try {
                    if (actionMustBeLocked) {
                        token.lock(lockOwnerId);
                    }
                    if (UserCodeInterceptorConfig.userCodeInterceptor != null) {
                        UserCodeInterceptorConfig.userCodeInterceptor.executeAction(action, executionContext);
                    } else {
                        action.execute(executionContext);
                    }
                }
                finally {
                    if (actionMustBeLocked) {
                        token.unlock(lockOwnerId);
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)("action threw exception: " + exception.getMessage()), (Throwable)exception);
                actionLog.setException(exception);
                this.raiseException(exception, executionContext);
                executionContext.setAction(null);
                token.endCompositeLog();
            }
        }
        finally {
            executionContext.setAction(null);
            token.endCompositeLog();
        }
    }

    List<Action> getRuntimeActionsForEvent(ExecutionContext executionContext, String eventType) {
        ArrayList<Action> actionsForEvent = null;
        List<RuntimeAction> runtimeActions = executionContext.getProcessInstance().getRuntimeActions();
        if (runtimeActions != null) {
            for (RuntimeAction runtimeAction : runtimeActions) {
                if (!this.equals(runtimeAction.getGraphElement()) || !eventType.equals(runtimeAction.getEventType())) continue;
                if (actionsForEvent == null) {
                    actionsForEvent = new ArrayList<Action>();
                }
                actionsForEvent.add(runtimeAction.getAction());
            }
        }
        return actionsForEvent;
    }

    public void raiseException(Throwable exception, ExecutionContext executionContext) throws DelegationException {
        if (GraphElement.isAbleToHandleExceptions(executionContext)) {
            GraphElement parent;
            if (this.exceptionHandlers != null) {
                try {
                    ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
                    if (exceptionHandler != null) {
                        executionContext.setException(exception);
                        exceptionHandler.handleException(this, executionContext);
                        return;
                    }
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if ((parent = this.getParent()) != null && !this.equals(parent)) {
                parent.raiseException(exception, executionContext);
                return;
            }
        }
        throw exception instanceof JbpmException ? (JbpmException)exception : new DelegationException(exception, executionContext);
    }

    private static boolean isAbleToHandleExceptions(ExecutionContext executionContext) {
        PersistenceService service;
        Services services;
        if (executionContext.getException() != null) {
            return false;
        }
        JbpmContext jbpmContext = executionContext.getJbpmContext();
        if (jbpmContext != null && (services = jbpmContext.getServices()) != null && (service = services.getPersistenceService()) instanceof DbPersistenceService) {
            DbPersistenceService persistenceService = (DbPersistenceService)service;
            return persistenceService.isTransactionActive() || persistenceService.getTransaction() == null;
        }
        return true;
    }

    protected ExceptionHandler findExceptionHandler(Throwable exception) {
        ExceptionHandler exceptionHandler = null;
        if (this.exceptionHandlers != null) {
            for (ExceptionHandler candidate : this.exceptionHandlers) {
                if (!candidate.matches(exception)) continue;
                exceptionHandler = candidate;
            }
        }
        return exceptionHandler;
    }

    public GraphElement getParent() {
        return this.processDefinition;
    }

    public List<GraphElement> getParents() {
        ArrayList<GraphElement> parents = new ArrayList<GraphElement>();
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.addParentChain(parents);
        }
        return parents;
    }

    public List<GraphElement> getParentChain() {
        ArrayList<GraphElement> parents = new ArrayList<GraphElement>();
        this.addParentChain(parents);
        return parents;
    }

    void addParentChain(List<GraphElement> parentChain) {
        parentChain.add(this);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.addParentChain(parentChain);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.name != null ? String.valueOf('(') + this.name + ')' : String.valueOf('@') + Integer.toHexString(this.hashCode()));
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }
}

