/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.util.CollectionUtil;

public class TaskMgmtSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Session session;
    final JbpmSession jbpmSession;
    private static final Log log = LogFactory.getLog(TaskMgmtSession.class);

    public TaskMgmtSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public TaskMgmtSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public List<TaskInstance> findTaskInstances(String actorId) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorId");
            query.setString("actorId", actorId);
            return CollectionUtil.checkList(query.list(), TaskInstance.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instances list for actor '" + actorId + "'", e);
        }
    }

    public List<TaskInstance> findTaskInstances(List<String> actorIds) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByActorIds");
            query.setParameterList("actorIds", actorIds);
            return CollectionUtil.checkList(query.list(), TaskInstance.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instances list for actors '" + actorIds + "'", e);
        }
    }

    public List<TaskInstance> findTaskInstances(String[] actorIds) {
        return this.findTaskInstances(Arrays.asList(actorIds));
    }

    public List<TaskInstance> findPooledTaskInstances(String actorId) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorId");
            query.setString("actorId", actorId);
            List<Long> taskInstanceIds = CollectionUtil.checkList(query.list(), Long.class);
            return this.findTaskInstancesByIds(taskInstanceIds);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get pooled task instances list for actor '" + actorId + "'", e);
        }
    }

    public List<TaskInstance> findPooledTaskInstances(List<String> actorIds) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findPooledTaskInstancesByActorIds");
            query.setParameterList("actorIds", actorIds);
            List<Long> taskInstanceIds = CollectionUtil.checkList(query.list(), Long.class);
            return this.findTaskInstancesByIds(taskInstanceIds);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get pooled task instances list for actors '" + actorIds + "'", e);
        }
    }

    public List<TaskInstance> findTaskInstancesByToken(long tokenId) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
            query.setLong("tokenId", tokenId);
            return CollectionUtil.checkList(query.list(), TaskInstance.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instances by token '" + tokenId + "'", e);
        }
    }

    public List<TaskInstance> findTaskInstancesByProcessInstance(ProcessInstance processInstance) {
        try {
            Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            return CollectionUtil.checkList(query.list(), TaskInstance.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instances by process instance '" + processInstance + "'", e);
        }
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instance '" + taskInstanceId + "'", e);
        }
        return taskInstance;
    }

    public TaskInstance getTaskInstance(long taskInstanceId) {
        TaskInstance taskInstance = null;
        try {
            taskInstance = (TaskInstance)this.session.get(TaskInstance.class, (Serializable)new Long(taskInstanceId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get task instance '" + taskInstanceId + "'", e);
        }
        return taskInstance;
    }

    public List<TaskInstance> findTaskInstancesByIds(List<Long> taskInstanceIds) {
        List<TaskInstance> result;
        if (taskInstanceIds.isEmpty()) {
            result = Collections.emptyList();
        } else {
            try {
                Query query = this.session.getNamedQuery("TaskMgmtSession.findTaskInstancesByIds");
                query.setParameterList("taskInstanceIds", taskInstanceIds);
                result = CollectionUtil.checkList(query.list(), TaskInstance.class);
            }
            catch (Exception e) {
                this.handle(e);
                throw new JbpmException("couldn't get task instances by ids '" + taskInstanceIds + "'", e);
            }
        }
        return result;
    }

    private void handle(Exception exception) {
        log.error((Object)exception);
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }
}

