/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;

public class JbpmSchema {
    final Configuration configuration;
    final Settings settings;
    ConnectionProvider connectionProvider = null;
    Connection connection = null;
    final List<SQLException> exceptions = new ArrayList<SQLException>();
    static String sqlDelimiter = null;
    private static final Log log = LogFactory.getLog(JbpmSchema.class);

    public JbpmSchema(Configuration configuration) {
        this.configuration = configuration;
        this.settings = configuration.buildSettings();
    }

    public String[] getCreateSql() {
        return this.configuration.generateSchemaCreationScript(this.settings.getDialect());
    }

    public String[] getDropSql() {
        return this.configuration.generateDropSchemaScript(this.settings.getDialect());
    }

    public String[] getCleanSql() {
        return JbpmSchema.concat(this.getDropSql(), this.getCreateSql());
    }

    public Set<String> getJbpmTables() {
        HashSet<String> jbpmTables = new HashSet<String>();
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!table.isPhysicalTable()) continue;
            jbpmTables.add(table.getName());
        }
        return jbpmTables;
    }

    public Set<String> getExistingTables() {
        try {
            this.createConnection();
            HashSet<String> existingTables = new HashSet<String>();
            DatabaseMetaData metaData = this.connection.getMetaData();
            boolean storesLowerCaseIdentifiers = metaData.storesLowerCaseIdentifiers();
            ResultSet resultSet = metaData.getTables(this.settings.getDefaultCatalogName(), this.settings.getDefaultSchemaName(), null, new String[]{"TABLE"});
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (storesLowerCaseIdentifiers) {
                        tableName = tableName.toUpperCase();
                    }
                    existingTables.add(tableName);
                }
            }
            finally {
                resultSet.close();
            }
            HashSet<String> hashSet = existingTables;
            return hashSet;
        }
        catch (SQLException e) {
            throw new JbpmException("could not get available table names", e);
        }
        finally {
            this.closeConnection();
        }
    }

    public Map<String, Long> getRowsPerTable() {
        HashMap<String, Long> rowsPerTable = new HashMap<String, Long>();
        try {
            try {
                this.createConnection();
                Statement statement = this.connection.createStatement();
                for (String tableName : this.getJbpmTables()) {
                    String sql = "SELECT COUNT(*) FROM " + tableName;
                    ResultSet resultSet = statement.executeQuery(sql);
                    if (!resultSet.next()) {
                        throw new JbpmException("empty result set: " + sql);
                    }
                    long count = resultSet.getLong(1);
                    if (resultSet.wasNull()) {
                        throw new JbpmException("count was null: " + sql);
                    }
                    rowsPerTable.put(tableName, count);
                    resultSet.close();
                }
                statement.close();
            }
            catch (SQLException e) {
                throw new JbpmException("could not count records", e);
            }
        }
        finally {
            this.closeConnection();
        }
        return rowsPerTable;
    }

    public void dropSchema() {
        try {
            this.execute(this.getDropSql());
        }
        catch (SQLException e) {
            throw new JbpmException("could not drop schema", e);
        }
    }

    public void createSchema() {
        try {
            this.execute(this.getCreateSql());
        }
        catch (SQLException e) {
            throw new JbpmException("could not create schema", e);
        }
    }

    public void cleanSchema() {
        try {
            this.execute(this.getCleanSql());
        }
        catch (SQLException e) {
            throw new JbpmException("could not clean schema", e);
        }
    }

    public void saveSqlScripts(String dir, String prefix) {
        try {
            new File(dir).mkdirs();
            this.saveSqlScript(String.valueOf(dir) + "/" + prefix + ".drop.sql", this.getDropSql());
            this.saveSqlScript(String.valueOf(dir) + "/" + prefix + ".create.sql", this.getCreateSql());
            this.saveSqlScript(String.valueOf(dir) + "/" + prefix + ".clean.sql", this.getCleanSql());
            this.saveSqlScript(String.valueOf(dir) + "/" + prefix + ".drop.create.sql", JbpmSchema.concat(this.getDropSql(), this.getCreateSql()));
        }
        catch (IOException e) {
            throw new JbpmException("couldn't generate scripts", e);
        }
    }

    private static String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        String[] result = new String[length1 + length2];
        System.arraycopy(array1, 0, result, 0, length1);
        System.arraycopy(array2, 0, result, length1, length2);
        return result;
    }

    public boolean tableExists(String tableName) {
        Table table = this.findTableMapping(tableName);
        try {
            this.createConnection();
            boolean bl = this.getTableMetadata(table) != null;
            return bl;
        }
        catch (SQLException e) {
            throw new JbpmException("could not tell whether table exists: " + tableName, e);
        }
        finally {
            this.closeConnection();
        }
    }

    public void createTable(String tableName) {
        Table table = this.findTableMapping(tableName);
        String sql = table.sqlCreateString(this.settings.getDialect(), this.configuration.buildMapping(), this.settings.getDefaultCatalogName(), this.settings.getDefaultSchemaName());
        try {
            this.execute(sql);
        }
        catch (SQLException e) {
            throw new JbpmException("could not create table: " + tableName, e);
        }
    }

    public void updateTable(String tableName) {
        Table table = this.findTableMapping(tableName);
        try {
            try {
                this.createConnection();
                Iterator sqls = table.sqlAlterStrings(this.settings.getDialect(), this.configuration.buildMapping(), this.getTableMetadata(table), this.settings.getDefaultCatalogName(), this.settings.getDefaultSchemaName());
                Statement statement = this.connection.createStatement();
                while (sqls.hasNext()) {
                    String sql = (String)sqls.next();
                    statement.executeUpdate(sql);
                }
                statement.close();
            }
            catch (SQLException e) {
                throw new JbpmException("could not update table: " + tableName, e);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public List<SQLException> getExceptions() {
        return this.exceptions;
    }

    private Table findTableMapping(String tableName) {
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        throw new JbpmException("no mapping found for table: " + tableName);
    }

    private TableMetadata getTableMetadata(Table table) throws SQLException {
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(this.connection, this.settings.getDialect());
        return databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? this.settings.getDefaultSchemaName() : table.getSchema(), table.getCatalog() == null ? this.settings.getDefaultCatalogName() : table.getCatalog(), table.isQuoted());
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            JbpmSchema.syntax();
        } else if ("create".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).createSchema();
        } else if ("drop".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).dropSchema();
        } else if ("clean".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).cleanSchema();
        } else if ("scripts".equalsIgnoreCase(args[0]) && args.length >= 3 && args.length <= 5) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 3);
            new JbpmSchema(configuration).saveSqlScripts(args[1], args[2]);
        } else {
            JbpmSchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("syntax:");
        System.err.println("JbpmSchema create [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema drop [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema clean [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema scripts <dir> <prefix> [<hibernate.cfg.xml> [<hibernate.properties>]]");
    }

    static Configuration createConfiguration(String[] args, int index) {
        String hibernateCfgXml = args.length > index ? args[index] : "hibernate.cfg.xml";
        String hibernateProperties = args.length > index + 1 ? args[index + 1] : null;
        Configuration configuration = new Configuration();
        configuration.configure(new File(hibernateCfgXml));
        if (hibernateProperties != null) {
            try {
                Properties properties = new Properties();
                FileInputStream inputStream = new FileInputStream(hibernateProperties);
                properties.load(inputStream);
                configuration.setProperties(properties);
            }
            catch (IOException e) {
                throw new JbpmException("couldn't load hibernate configuration", e);
            }
        }
        return configuration;
    }

    void saveSqlScript(String fileName, String[] sql) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(fileName));
        try {
            String[] stringArray = sql;
            int n = sql.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                out.println(String.valueOf(line) + this.getSqlDelimiter());
                ++n2;
            }
        }
        finally {
            out.close();
        }
    }

    void execute(String ... sqls) throws SQLException {
        boolean showSql = this.settings.isShowSqlEnabled();
        this.exceptions.clear();
        try {
            this.createConnection();
            Statement statement = this.connection.createStatement();
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                if (showSql) {
                    System.out.println(sql);
                }
                log.debug((Object)sql);
                try {
                    statement.executeUpdate(sql);
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    log.debug((Object)e.getMessage());
                }
                ++n2;
            }
            statement.close();
        }
        finally {
            this.closeConnection();
        }
    }

    void createConnection() throws SQLException {
        this.connectionProvider = this.settings.getConnectionProvider();
        this.connection = this.connectionProvider.getConnection();
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    void closeConnection() {
        if (this.connection != null) {
            try {
                try {
                    JDBCExceptionReporter.logAndClearWarnings((Connection)this.connection);
                    this.connectionProvider.closeConnection(this.connection);
                }
                catch (SQLException e) {
                    log.debug((Object)("could not close " + this.connection), (Throwable)e);
                    this.connectionProvider.close();
                }
            }
            finally {
                this.connectionProvider.close();
            }
        }
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    synchronized String getSqlDelimiter() {
        if (sqlDelimiter == null) {
            sqlDelimiter = this.getProperties().getProperty("jbpm.sql.delimiter", ";");
        }
        return sqlDelimiter;
    }
}

