/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.converter;

import org.jbpm.context.exe.Converter;
import org.jbpm.db.hibernate.Converters;

public class BooleanToStringConverter
implements Converter<Boolean, String> {
    private static final long serialVersionUID = 1L;
    public static final String TRUE_TEXT = "T";
    public static final String FALSE_TEXT = "F";

    public BooleanToStringConverter() {
        Converters.registerConverter("B", this);
    }

    @Override
    public boolean supports(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public String convert(Boolean o) {
        String convertedValue = FALSE_TEXT;
        if (o.booleanValue()) {
            convertedValue = TRUE_TEXT;
        }
        return convertedValue;
    }

    @Override
    public Boolean revert(String o) {
        Boolean revertedValue = Boolean.FALSE;
        if (TRUE_TEXT.equals(o)) {
            revertedValue = Boolean.TRUE;
        }
        return revertedValue;
    }
}

