/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class StartWorkOnTaskCommand
extends AbstractBaseCommand {
    private static final long serialVersionUID = 53004484398726736L;
    private static final Log log = LogFactory.getLog(StartWorkOnTaskCommand.class);
    private long taskInstanceId;
    private boolean overwriteSwimlane = false;
    private String actorId;

    public StartWorkOnTaskCommand(long taskInstanceId, boolean overwriteSwimlane) {
        this.taskInstanceId = taskInstanceId;
        this.overwriteSwimlane = overwriteSwimlane;
    }

    public StartWorkOnTaskCommand() {
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        String actor = this.actorId == null ? jbpmContext.getActorId() : this.actorId;
        TaskInstance taskInstance = jbpmContext.getTaskInstance(this.taskInstanceId);
        if (taskInstance.getStart() != null) {
            log.warn((Object)("Force stop on task " + taskInstance.getId() + ". Will be restarted."));
            taskInstance.setStart(null);
        }
        taskInstance.start(actor, this.overwriteSwimlane);
        return null;
    }

    public boolean isOverwriteSwimlane() {
        return this.overwriteSwimlane;
    }

    public void setOverwriteSwimlane(boolean overwriteSwimlane) {
        this.overwriteSwimlane = overwriteSwimlane;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public String getActorId() {
        return this.actorId;
    }

    @Override
    public String getAdditionalToStringInformation() {
        return "tokenId=" + this.taskInstanceId + ";transitionName=" + this.actorId + ";processDefinitionName=" + this.overwriteSwimlane;
    }

    public StartWorkOnTaskCommand overwriteSwimlane(boolean overwriteSwimlane) {
        this.setOverwriteSwimlane(overwriteSwimlane);
        return this;
    }

    public StartWorkOnTaskCommand taskInstanceId(long taskInstanceId) {
        this.setTaskInstanceId(taskInstanceId);
        return this;
    }

    public StartWorkOnTaskCommand actorId(String actorId) {
        this.setActorId(actorId);
        return this;
    }
}

