/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class GetTaskListCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -1627380259541998349L;
    static final Log log = LogFactory.getLog(GetTaskListCommand.class);
    private String[] actor;

    public GetTaskListCommand(String[] actor) {
        this.setActor(actor);
    }

    public GetTaskListCommand(String actor, boolean includeVariables) {
        super(includeVariables, false);
        this.setActor(actor);
    }

    public GetTaskListCommand(String actor, String[] variablesToInclude) {
        super(variablesToInclude);
        this.setActor(actor);
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.setJbpmContext(jbpmContext);
        List<TaskInstance> result = null;
        if (this.actor == null || this.actor.length == 0) {
            result = jbpmContext.getTaskList();
        } else {
            result = new ArrayList<TaskInstance>();
            int i = 0;
            while (i < this.actor.length) {
                result.addAll(jbpmContext.getTaskList(this.actor[i]));
                ++i;
            }
            result.addAll(jbpmContext.getGroupTaskList(Arrays.asList(this.actor)));
        }
        return this.retrieveTaskInstanceDetails(result);
    }

    public List retrieveTaskInstanceDetails(List taskInstanceList) {
        Iterator iter = taskInstanceList.iterator();
        while (iter.hasNext()) {
            this.retrieveTaskInstanceDetails((TaskInstance)iter.next());
        }
        return taskInstanceList;
    }

    public String[] getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = new String[]{actor};
    }

    public void setActor(String[] actor) {
        this.actor = actor;
    }

    @Override
    public String getAdditionalToStringInformation() {
        return "actors=" + Arrays.toString(this.actor);
    }

    public GetTaskListCommand actor(String actor) {
        this.actor = new String[]{actor};
        return this;
    }

    public GetTaskListCommand actor(String[] actor) {
        this.actor = actor;
        return this;
    }
}

