/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.exe.ProcessInstance;

public class GetProcessInstancesCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -5601050489405283851L;
    private boolean onlyRunning = true;
    private Date fromStartDate;
    private Date untilStartDate;
    private String processDefinitionName;
    private long processInstanceId = -1L;
    private String stateName;
    private String version = null;
    private transient boolean firstExpression = true;

    private String getConcatExpression() {
        if (this.firstExpression) {
            this.firstExpression = false;
            return " where ";
        }
        return " and ";
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.setJbpmContext(jbpmContext);
        this.firstExpression = true;
        StringBuffer queryText = new StringBuffer("select pi from org.jbpm.graph.exe.ProcessInstance as pi ");
        if (this.onlyRunning) {
            queryText.append(this.getConcatExpression()).append(" pi.end = null");
        }
        if (this.fromStartDate != null) {
            queryText.append(this.getConcatExpression()).append(" pi.start >= :from ");
        }
        if (this.untilStartDate != null) {
            queryText.append(this.getConcatExpression()).append(" pi.start <= :until ");
        }
        if (this.version != null) {
            queryText.append(this.getConcatExpression()).append(" pi.version = :version ");
        }
        if (this.processInstanceId != -1L) {
            queryText.append(this.getConcatExpression()).append(" pi.processDefinition.id = :processId  ");
        } else if (this.processDefinitionName != null && this.processDefinitionName.length() > 0) {
            queryText.append(this.getConcatExpression()).append(" pi.processDefinition.name = :processDefinitionName  ");
        }
        if (this.stateName != null && this.stateName.length() > 0) {
            queryText.append(this.getConcatExpression()).append(" pi.rootToken.node.name = :nodeName ");
        }
        queryText.append(" order by pi.start desc");
        Query query = jbpmContext.getSession().createQuery(queryText.toString());
        if (this.fromStartDate != null) {
            query.setTimestamp("from", this.fromStartDate);
        }
        if (this.untilStartDate != null) {
            query.setTimestamp("until", this.untilStartDate);
        }
        if (this.processInstanceId != -1L) {
            query.setLong("processId", this.processInstanceId);
        }
        if (this.processDefinitionName != null && this.processDefinitionName.length() > 0) {
            query.setString("processDefinitionName", this.processDefinitionName);
        }
        if (this.stateName != null && this.stateName.length() > 0) {
            query.setString("nodeName", this.stateName);
        }
        if (this.version != null) {
            query.setString("version", this.version);
        }
        return this.retrieveProcessInstanceDetails(query.list());
    }

    public List retrieveProcessInstanceDetails(List processInstanceList) {
        Iterator it = processInstanceList.iterator();
        while (it.hasNext()) {
            this.retrieveProcessInstance((ProcessInstance)it.next());
        }
        return processInstanceList;
    }

    public Date getFromStartDate() {
        return this.fromStartDate;
    }

    public void setFromStartDate(Date fromStartDate) {
        this.fromStartDate = fromStartDate;
    }

    public boolean isOnlyRunning() {
        return this.onlyRunning;
    }

    public void setOnlyRunning(boolean onlyRunning) {
        this.onlyRunning = onlyRunning;
    }

    public String getProcessName() {
        return this.processDefinitionName;
    }

    public void setProcessName(String processName) {
        this.processDefinitionName = processName;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processName) {
        this.processDefinitionName = processName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Date getUntilStartDate() {
        return this.untilStartDate;
    }

    public void setUntilStartDate(Date untilStartDate) {
        this.untilStartDate = untilStartDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processId) {
        this.processInstanceId = processId;
    }

    public long getProcessId() {
        return this.processInstanceId;
    }

    public void setProcessId(long processId) {
        this.processInstanceId = processId;
    }

    @Override
    public String getAdditionalToStringInformation() {
        return "processInstanceId=" + this.processInstanceId + ";processDefinitionName=" + this.processDefinitionName + ";version=" + this.version + ";stateName=" + this.stateName + ";fromStartDate=" + this.fromStartDate + ";untilStartDate=" + this.untilStartDate + ";onlyRunning=" + this.onlyRunning;
    }

    public GetProcessInstancesCommand fromStartDate(Date fromStartDate) {
        this.setFromStartDate(fromStartDate);
        return this;
    }

    public GetProcessInstancesCommand onlyRunning(boolean onlyRunning) {
        this.setOnlyRunning(onlyRunning);
        return this;
    }

    public GetProcessInstancesCommand processDefinitionName(String processName) {
        this.setProcessDefinitionName(processName);
        return this;
    }

    public GetProcessInstancesCommand stateName(String stateName) {
        this.setStateName(stateName);
        return this;
    }

    public GetProcessInstancesCommand untilStartDate(Date untilStartDate) {
        this.setUntilStartDate(untilStartDate);
        return this;
    }

    public GetProcessInstancesCommand version(String version) {
        this.setVersion(version);
        return this;
    }

    public GetProcessInstancesCommand processInstanceId(long processId) {
        this.setProcessInstanceId(processId);
        return this;
    }
}

