/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.exe.ProcessInstance;

public class GetProcessInstanceCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -8436697080972165601L;
    private long processInstanceId;
    private long tokenId;
    private long taskInstanceId;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetProcessInstanceCommand(long processInstanceId, boolean includeVariables, boolean includeLogs) {
        super(true, true);
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.setJbpmContext(jbpmContext);
        ProcessInstance processInstance = null;
        if (this.processInstanceId != 0L) {
            processInstance = jbpmContext.getProcessInstance(this.processInstanceId);
        } else if (this.tokenId != 0L) {
            processInstance = jbpmContext.getToken(this.tokenId).getProcessInstance();
        } else if (this.taskInstanceId != 0L) {
            processInstance = jbpmContext.getTaskInstance(this.taskInstanceId).getProcessInstance();
        }
        if (processInstance != null) {
            processInstance = this.retrieveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    @Override
    public String getAdditionalToStringInformation() {
        return "processInstanceId=" + this.processInstanceId + ";tokenId=" + this.tokenId + ";taskInstanceId=" + this.taskInstanceId;
    }

    public GetProcessInstanceCommand processInstanceId(long processInstanceId) {
        this.setProcessInstanceId(processInstanceId);
        return this;
    }

    public GetProcessInstanceCommand taskInstanceId(long taskInstanceId) {
        this.setTaskInstanceId(taskInstanceId);
        return this;
    }

    public GetProcessInstanceCommand tokenId(long tokenId) {
        this.setTokenId(tokenId);
        return this;
    }
}

