/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;

public class CompositeCommand
implements Command {
    private static final long serialVersionUID = 1L;
    List commands = null;

    public CompositeCommand(List commands) {
        this.commands = commands;
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        ArrayList<Object> results = null;
        if (this.commands != null) {
            Object lastResult = null;
            results = new ArrayList<Object>(this.commands.size());
            for (Command command : this.commands) {
                if (lastResult != null) {
                    this.tryToInject(lastResult, command);
                }
                lastResult = command.execute(jbpmContext);
                results.add(lastResult);
            }
        }
        return results;
    }

    protected void tryToInject(Object lastResult, Command command) {
        Field field = this.findField(lastResult.getClass());
        if (field != null) {
            field.setAccessible(true);
            try {
                field.set(command, lastResult);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't propagate composite command context", e);
            }
        }
    }

    protected Field findField(Class clazz) {
        Field field = null;
        int i = 0;
        Field[] fields = clazz.getDeclaredFields();
        while (i < fields.length && field == null) {
            Field candidate = fields[i];
            if (candidate.getType().isAssignableFrom(clazz) && candidate.getName().startsWith("previous")) {
                field = candidate;
            }
            ++i;
        }
        return field;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " consists of (" + this.commands + ")";
    }
}

