/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.Token;
import org.jbpm.util.CollectionUtil;

public abstract class AbstractTokenBaseCommand
implements Command {
    protected Log log = LogFactory.getLog(this.getClass());
    private long[] tokenIds = null;
    private String processName = null;
    private String stateName = null;
    private int processVersion = 0;
    private boolean operateOnSingleObject;
    private transient JbpmContext jbpmContext;
    private static final long serialVersionUID = 1L;

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    @Override
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            this.log.debug((Object)("executing " + this));
            if (this.tokenIds != null && this.tokenIds.length > 0) {
                int i = 0;
                while (i < this.tokenIds.length) {
                    Token token = jbpmContext.loadTokenForUpdate(this.tokenIds[i]);
                    result.add(this.execute(token));
                    ++i;
                }
            } else {
                this.operateOnSingleObject = false;
                Criteria criteria = jbpmContext.getSession().createCriteria(Token.class);
                if (this.processName != null) {
                    criteria.createCriteria("processInstance").createCriteria("processDefinition").add((Criterion)Restrictions.eq((String)"name", (Object)this.processName));
                }
                if (this.processVersion > 0) {
                    criteria.createCriteria("processInstance").createCriteria("processDefinition").add((Criterion)Restrictions.eq((String)"version", (Object)this.processVersion));
                }
                if (this.stateName != null) {
                    criteria.createCriteria("node").add((Criterion)Restrictions.eq((String)"name", (Object)this.stateName));
                }
                List queryResult = criteria.list();
                CollectionUtil.checkList(queryResult, Token.class);
                for (Token token : queryResult) {
                    result.add(this.execute(token));
                }
            }
            if (this.operateOnSingleObject) {
                if (result.size() < 1) {
                    return null;
                }
                Object e = result.get(0);
                return e;
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            this.jbpmContext = null;
        }
    }

    public abstract Object execute(Token var1);

    public void setTokenIds(long[] tokenIds) {
        this.operateOnSingleObject = false;
        this.tokenIds = tokenIds;
    }

    public void setTokenId(long tokenId) {
        this.operateOnSingleObject = true;
        this.tokenIds = new long[1];
        this.tokenIds[0] = tokenId;
    }

    public String getAdditionalToStringInformation() {
        return "";
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public long[] getTokenIds() {
        return this.tokenIds;
    }

    public long getTokenId() {
        if (this.tokenIds == null || this.tokenIds.length != 1) {
            throw new IllegalStateException("exactly one token id must be set on " + this + " to get tokenId property; found " + Arrays.toString(this.tokenIds));
        }
        return this.tokenIds[0];
    }

    public String toString() {
        if (this.processName != null && this.stateName != null) {
            return String.valueOf(this.getClass().getName()) + " [tokenIds=" + Arrays.toString(this.tokenIds) + ";processName=" + this.processName + ";processVersion=" + (this.processVersion > 0 ? Integer.valueOf(this.processVersion) : "NA") + ";stateName=" + this.stateName + this.getAdditionalToStringInformation() + "]";
        }
        return String.valueOf(this.getClass().getName()) + " [tokenIds=" + Arrays.toString(this.tokenIds) + ";operateOnSingleObject=" + this.operateOnSingleObject + this.getAdditionalToStringInformation() + "]";
    }

    public AbstractTokenBaseCommand tokenIds(long[] tokenIds) {
        this.setTokenIds(tokenIds);
        return this;
    }

    public AbstractTokenBaseCommand tokenId(long tokenId) {
        this.setTokenId(tokenId);
        return this;
    }

    public AbstractTokenBaseCommand processName(String processName) {
        this.setProcessName(processName);
        return this;
    }

    public AbstractTokenBaseCommand processVersion(int processVersion) {
        this.setProcessVersion(processVersion);
        return this;
    }

    public AbstractTokenBaseCommand stateName(String stateName) {
        this.setStateName(stateName);
        return this;
    }

    public boolean isOperateOnSingleObject() {
        return this.operateOnSingleObject;
    }
}

