/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;

public class DeployProcessTask
extends MatchingTask {
    String jbpmCfg = null;
    File process = null;
    List fileSets = new ArrayList();
    boolean failOnError = true;

    public void execute() throws BuildException {
        JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration(this.jbpmCfg);
        if (this.process != null) {
            this.deployProcessArchive(jbpmConfiguration, this.process);
        }
        for (FileSet fileSet : this.fileSets) {
            DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
            File baseDir = dirScanner.getBasedir();
            String[] includedFiles = dirScanner.getIncludedFiles();
            List<String> excludedFiles = Arrays.asList(dirScanner.getExcludedFiles());
            int i = 0;
            while (i < includedFiles.length) {
                String fileName = includedFiles[i];
                if (!excludedFiles.contains(fileName)) {
                    File file = new File(baseDir, fileName);
                    this.deployProcessArchive(jbpmConfiguration, file);
                }
                ++i;
            }
        }
    }

    private void deployProcessArchive(JbpmConfiguration jbpmConfiguration, File processFile) {
        try {
            this.log("deploying process from archive " + processFile.getName());
            ProcessDefinition processDefinition = this.parseProcessArchive(processFile);
            this.deployProcessDefinition(processDefinition, jbpmConfiguration);
        }
        catch (IOException e) {
            this.log("failed to read process archive " + processFile.getName(), e, 0);
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (JpdlException e) {
            this.log("archive " + processFile.getName() + " contains invalid process", e, 0);
            throw e;
        }
    }

    private ProcessDefinition parseProcessArchive(File processFile) throws IOException {
        ZipInputStream processStream = new ZipInputStream(new FileInputStream(processFile));
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(processStream);
            this.log("created process definition " + processDefinition.getName());
            ProcessDefinition processDefinition2 = processDefinition;
            return processDefinition2;
        }
        finally {
            processStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition, JbpmConfiguration jbpmConfiguration) {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            try {
                jbpmContext.deployProcessDefinition(processDefinition);
                this.log("deployed process " + processDefinition.getName() + " successfully");
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                this.log("failed to deploy process " + processDefinition.getName(), e, 0);
                throw e;
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setProcess(File process) {
        this.process = process;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

