/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.job.Job;
import org.jbpm.job.executor.Deactivable;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class LockMonitorThread
extends Thread
implements Deactivable {
    public static final String DEFAULT_NAME = "Monitor";
    private final JobExecutor jobExecutor;
    private volatile boolean active = true;
    private static Log log = LogFactory.getLog((Class)LockMonitorThread.class);

    public LockMonitorThread(JobExecutor jobExecutor) {
        this(DEFAULT_NAME, jobExecutor);
    }

    public LockMonitorThread(String name, JobExecutor jobExecutor) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public LockMonitorThread(JbpmConfiguration jbpmConfiguration, int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.jobExecutor = jbpmConfiguration.getJobExecutor();
    }

    public void run() {
        while (this.active) {
            try {
                this.unlockOverdueJobs();
            }
            catch (RuntimeException e) {
                log.error((Object)("exception in " + this.getName()), (Throwable)e);
            }
            if (!this.active) continue;
            try {
                LockMonitorThread.sleep(this.jobExecutor.getLockMonitorInterval());
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(this.getName() + " got interrupted"));
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    protected void unlockOverdueJobs() {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            Date threshold = new Date(System.currentTimeMillis() - (long)this.jobExecutor.getMaxLockTime());
            List overdueJobs = jbpmContext.getJobSession().findJobsWithOverdueLockTime(threshold);
            Iterator i = overdueJobs.iterator();
            while (i.hasNext()) {
                Job job = (Job)i.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unlocking " + job));
                }
                job.setLockOwner(null);
                job.setLockTime(null);
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (!DbPersistenceService.isLockingException(e)) {
                throw e;
            }
            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)"could not unlock overdue jobs", (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                if (!DbPersistenceService.isLockingException(e)) {
                    throw e;
                }
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)"could not unlock overdue jobs", (Throwable)e);
            }
        }
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.interrupt();
        }
    }
}

