/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.Script;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Fork
extends Node {
    private static final long serialVersionUID = 1L;
    Script script;

    public Fork() {
    }

    public Fork(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Fork;
    }

    public void read(Element forkElement, JpdlXmlReader jpdlReader) {
    }

    public void execute(ExecutionContext executionContext) {
        ArrayList<String> transitionNames;
        if (this.script == null) {
            List transitions = this.getLeavingTransitions();
            transitionNames = new ArrayList<String>(transitions.size());
            Iterator iter = transitions.iterator();
            while (iter.hasNext()) {
                Transition transition = (Transition)iter.next();
                transitionNames.add(transition.getName());
            }
        } else {
            transitionNames = this.evaluateScript(executionContext);
        }
        Token token = executionContext.getToken();
        token.lock(this.toString());
        HashMap<String, Token> childTokens = new HashMap<String, Token>();
        Iterator<Object> iter = transitionNames.iterator();
        while (iter.hasNext()) {
            String transitionName = (String)iter.next();
            Token childToken = this.createForkedToken(token, transitionName);
            childTokens.put(transitionName, childToken);
        }
        iter = childTokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String transitionName = (String)entry.getKey();
            Token childToken = (Token)entry.getValue();
            this.leave(new ExecutionContext(childToken), transitionName);
        }
    }

    private Collection evaluateScript(ExecutionContext executionContext) {
        Object result;
        Map outputMap = this.script.eval(executionContext);
        if (outputMap.size() == 1 && (result = outputMap.values().iterator().next()) instanceof Collection) {
            return (Collection)result;
        }
        throw new JbpmException("expected " + this.script + " to write one collection variable, output was: " + outputMap);
    }

    protected Token createForkedToken(Token parent, String transitionName) {
        return new Token(parent, this.getTokenName(parent, transitionName));
    }

    protected String getTokenName(Token parent, String transitionName) {
        if (transitionName != null) {
            String tokenName;
            if (!parent.hasChild(transitionName)) {
                return transitionName;
            }
            StringBuffer tokenText = new StringBuffer(transitionName);
            int baseLength = transitionName.length();
            int suffix = 2;
            do {
                tokenText.append(suffix++);
                tokenName = tokenText.toString();
                tokenText.setLength(baseLength);
            } while (parent.hasChild(tokenName));
            return tokenName;
        }
        Map childTokens = parent.getChildren();
        return childTokens != null ? Integer.toString(childTokens.size() + 1) : "1";
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }
}

