/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ActionTypes {
    private static Map typesByResource = new HashMap();
    private static final Log log = LogFactory.getLog((Class)ActionTypes.class);

    public static Collection getActionTypes() {
        return ActionTypes.getTypes().values();
    }

    public static Set getActionNames() {
        return ActionTypes.getTypes().keySet();
    }

    public static Class getActionType(String name) {
        return (Class)ActionTypes.getTypes().get(name);
    }

    public static String getActionName(Class type) {
        Iterator iter = ActionTypes.getTypes().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (type != entry.getValue()) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static boolean hasActionName(String name) {
        return ActionTypes.getTypes().containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getTypes() {
        String resource = JbpmConfiguration.Configs.getString("resource.action.types");
        Map map = typesByResource;
        synchronized (map) {
            Map types = (Map)typesByResource.get(resource);
            if (types == null) {
                types = ActionTypes.initialiseActionTypes(resource);
                typesByResource.put(resource, types);
            }
            return types;
        }
    }

    private static Map initialiseActionTypes(String resource) {
        HashMap<String, Class> types = new HashMap<String, Class>();
        InputStream actionTypesStream = ClassLoaderUtil.getStream(resource);
        Element actionTypesElement = XmlUtil.parseXmlInputStream(actionTypesStream).getDocumentElement();
        Iterator iter = XmlUtil.elementIterator(actionTypesElement, "action-type");
        while (iter.hasNext()) {
            Element actionTypeElement = (Element)iter.next();
            String elementTag = actionTypeElement.getAttribute("element");
            String className = actionTypeElement.getAttribute("class");
            try {
                Class actionClass = ClassLoaderUtil.classForName(className);
                types.put(elementTag, actionClass);
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("action '" + elementTag + "' will not be available, class not found: " + className));
            }
        }
        return types;
    }
}

