/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jboss.bpm.incubator.service.IdentityService;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.identity.Group;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.integration.spec.service.MutableService;
import org.jbpm.integration.spec.service.ProcessEngineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityServiceImpl
extends AbstractService
implements IdentityService,
MutableService {
    final Logger log = LoggerFactory.getLogger(IdentityServiceImpl.class);

    @Override
    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public List<String> getActors() {
        ArrayList<String> actors = new ArrayList<String>();
        IdentitySession identSession = this.getIdentitySession();
        try {
            actors.addAll(identSession.getUsers());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            identSession.close();
        }
        return actors;
    }

    public List<String> getActorsByGroup(String group) {
        ArrayList<String> actors = new ArrayList<String>();
        IdentitySession identSession = this.getIdentitySession();
        try {
            Group identGroup = identSession.getGroupByName(group);
            for (User user : identGroup.getUsers()) {
                actors.add(user.getName());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            identSession.close();
        }
        return actors;
    }

    public List<String> getGroups() {
        throw new NotImplementedException();
    }

    public List<String> getGroupsByActor(String actor) {
        ArrayList<String> groups = new ArrayList<String>();
        IdentitySession identSession = this.getIdentitySession();
        try {
            User identUser = identSession.getUserByName(actor);
            for (Group group : identUser.getGroupsForGroupType("organisation")) {
                groups.add(group.getName());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        finally {
            identSession.close();
        }
        return groups;
    }

    private IdentitySession getIdentitySession() {
        ProcessEngineImpl engineImpl = (ProcessEngineImpl)this.getProcessEngine();
        JbpmConfiguration jbpmConfig = engineImpl.getJbpmConfiguration();
        JbpmContext jbpmContext = jbpmConfig.createJbpmContext();
        IdentitySession identSession = new IdentitySession(jbpmContext.getSession());
        return identSession;
    }
}

