/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model;

import org.jboss.bpm.incubator.model.Expression;
import org.jboss.bpm.incubator.model.SequenceFlow;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.spec.model.ExpressionImpl;

public class SequenceFlowImpl
implements SequenceFlow {
    private static final long serialVersionUID = 1L;
    private Transition oldTrans;
    private SequenceFlow.ConditionType condType = SequenceFlow.ConditionType.None;
    private Expression expr;

    public SequenceFlowImpl(Transition oldTrans) {
        this.oldTrans = oldTrans;
    }

    public SequenceFlowImpl(Transition oldTrans, Expression.ExpressionLanguage exprLang, String exprBody) {
        this.oldTrans = oldTrans;
        if (exprLang != null && exprBody != null) {
            this.condType = SequenceFlow.ConditionType.Expression;
            this.expr = new ExpressionImpl(exprLang, exprBody);
        }
    }

    public SequenceFlowImpl(Transition oldTrans, boolean isDefault) {
        this.oldTrans = oldTrans;
        this.condType = SequenceFlow.ConditionType.Default;
    }

    public Transition getOldTransition() {
        return this.oldTrans;
    }

    public String getName() {
        return this.oldTrans.getName();
    }

    public Expression getConditionExpression() {
        return this.expr;
    }

    public SequenceFlow.ConditionType getConditionType() {
        return this.condType;
    }

    public String getSourceRef() {
        Node from = this.oldTrans.getFrom();
        return from != null ? from.getName() : null;
    }

    public String getTargetRef() {
        Node to = this.oldTrans.getTo();
        return to != null ? to.getName() : null;
    }

    public String toString() {
        return "[" + this.getSourceRef() + "->" + this.getTargetRef() + ",cond=" + this.condType + "]";
    }
}

