/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.assignment.ExpressionSession;
import org.jbpm.identity.security.IdentityService;
import org.jbpm.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySession
implements IdentityService,
ExpressionSession {
    private static final Log log = LogFactory.getLog(IdentitySession.class);
    Session session;
    private Transaction transaction;

    public IdentitySession(Session session) {
        this.session = session;
    }

    public IdentitySession() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null || jbpmContext.getSession() == null || !jbpmContext.getSession().isOpen()) {
            throw new RuntimeException("no active JbpmContext to create an identity session");
        }
        this.session = jbpmContext.getSession();
    }

    @Override
    public Long verify(String userName, String pwd) {
        Query query = this.session.createQuery("select user.id from org.jbpm.identity.User as user where user.name = :userName and user.password = :password");
        query.setString("userName", userName);
        query.setString("password", pwd);
        return (Long)query.uniqueResult();
    }

    @Override
    public User getUserById(Object userId) {
        return (User)this.session.load(User.class, (Serializable)((Long)userId));
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void beginTransaction() {
        try {
            this.transaction = this.session.beginTransaction();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("could not begin transaction", (Throwable)e);
        }
    }

    public void commitTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("cannot commit : no transaction started");
        }
        try {
            this.session.flush();
            this.transaction.commit();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("could not commit transaction", (Throwable)e);
        }
        this.transaction = null;
    }

    public void rollbackTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("cannot rollback : no transaction started");
        }
        try {
            this.transaction.rollback();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("could not rollback transaction", (Throwable)e);
        }
        this.transaction = null;
    }

    public void commitTransactionAndClose() {
        this.commitTransaction();
        this.close();
    }

    public void rollbackTransactionAndClose() {
        this.rollbackTransaction();
        this.close();
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("could not close hibernate session", (Throwable)e);
        }
    }

    public void saveUser(User user) {
        this.session.save((Object)user);
    }

    public void saveGroup(Group group) {
        this.session.save((Object)group);
    }

    public void saveEntity(Entity entity) {
        this.session.save((Object)entity);
    }

    public void saveMembership(Membership membership) {
        this.session.save((Object)membership);
    }

    public User loadUser(long userId) {
        return (User)this.session.load(User.class, (Serializable)new Long(userId));
    }

    public Group loadGroup(long groupId) {
        return (Group)this.session.load(Group.class, (Serializable)new Long(groupId));
    }

    public void deleteGroup(Group group) {
        this.session.delete((Object)group);
    }

    public void deleteUser(User user) {
        this.session.delete((Object)user);
    }

    @Override
    public User getUserByName(String userName) {
        Criteria criteria = this.session.createCriteria(User.class).add((Criterion)Restrictions.eq((String)"name", (Object)userName));
        List users = CollectionUtil.checkList((List)criteria.list(), User.class);
        return users.isEmpty() ? null : (User)users.get(0);
    }

    @Override
    public Group getGroupByName(String groupName) {
        Criteria criteria = this.session.createCriteria(Group.class).add((Criterion)Restrictions.eq((String)"name", (Object)groupName));
        List groups = CollectionUtil.checkList((List)criteria.list(), Group.class);
        return groups.isEmpty() ? null : (Group)groups.get(0);
    }

    public List<User> getUsers() {
        Criteria criteria = this.session.createCriteria(User.class);
        return CollectionUtil.checkList((List)criteria.list(), User.class);
    }

    public List<String> getGroupNamesByUserAndGroupType(String userName, String groupType) {
        Criteria criteria = this.session.createCriteria(Membership.class).createAlias("user", "u").createAlias("group", "g").add((Criterion)Restrictions.eq((String)"u.name", (Object)userName)).add((Criterion)Restrictions.eq((String)"g.type", (Object)groupType)).setProjection((Projection)Projections.property((String)"g.name"));
        return CollectionUtil.checkList((List)criteria.list(), String.class);
    }

    @Override
    public User getUserByGroupAndRole(String groupName, String role) {
        Criteria criteria = this.session.createCriteria(Membership.class).add((Criterion)Restrictions.eq((String)"role", (Object)role)).createAlias("group", "g").add((Criterion)Restrictions.eq((String)"g.name", (Object)groupName)).setProjection((Projection)Projections.property((String)"user"));
        return (User)criteria.uniqueResult();
    }
}

