/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Entity {
    private static final long serialVersionUID = 1L;
    protected String type = null;
    protected Group parent = null;
    protected Set<Group> children = null;
    protected Set<Membership> memberships = null;

    public Group() {
    }

    public Group(String name) {
        super(name);
    }

    public Group(String name, String type) {
        super(name);
        this.type = type;
    }

    public void addMembership(Membership membership) {
        if (this.memberships == null) {
            this.memberships = new HashSet<Membership>();
        }
        this.memberships.add(membership);
        membership.setGroup(this);
    }

    public void addChild(Group child) {
        if (this.children == null) {
            this.children = new HashSet<Group>();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public Set<User> getUsers() {
        Set<User> users;
        if (this.memberships != null) {
            users = new HashSet();
            for (Membership membership : this.memberships) {
                users.add(membership.getUser());
            }
        } else {
            users = Collections.emptySet();
        }
        return users;
    }

    public Set<User> getUsersForMembershipRole(String membershipRole) {
        Set<User> users;
        if (this.memberships != null) {
            users = new HashSet();
            for (Membership membership : this.memberships) {
                if (!membershipRole.equals(membership.getRole())) continue;
                users.add(membership.getUser());
            }
        } else {
            users = Collections.emptySet();
        }
        return users;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public Set<Group> getChildren() {
        return this.children;
    }

    public Group getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChildren(Set<Group> children) {
        this.children = children;
    }

    public void setMemberships(Set<Membership> memberships) {
        this.memberships = memberships;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }
}

