/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import com.google.common.base.Strings;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.xes.XESExportService;
import org.jbpm.xes.XESLogMarshaller;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.dataset.DataSetUtils;
import org.jbpm.xes.mapper.ColumnFilterMapper;
import org.jbpm.xes.mapper.EventTypeMapper;
import org.jbpm.xes.mapper.LogTypeMapper;
import org.jbpm.xes.mapper.TraceTypeMapper;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.TraceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XESExportServiceImpl
implements XESExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XESExportServiceImpl.class);
    private DataSetService dataSetService;
    private XESLogMarshaller marshaller = new XESLogMarshaller();

    public void setDataSetService(DataSetService dataSetService) {
        this.dataSetService = dataSetService;
    }

    @Override
    public String export(XESProcessFilter filter) throws Exception {
        if (filter == null || Strings.isNullOrEmpty((String)filter.getProcessId())) {
            throw new RuntimeException("Process Id must be provided for filtering the logs");
        }
        LOGGER.info("Starting XES export...");
        LOGGER.debug("XES filter: {}", (Object)filter);
        LocalDateTime start = LocalDateTime.now();
        List<ColumnFilter> filters = new ColumnFilterMapper().apply(filter);
        DataSet tracesDataSet = this.dataSetService.findTraces(filters.toArray(new ColumnFilter[filters.size()]));
        LOGGER.debug("Found {} process instances to export.", (Object)tracesDataSet.getRowCount());
        if (tracesDataSet.getRowCount() == 0) {
            LOGGER.warn("Could not find any process instance to export, please review filter: {}", (Object)filter);
            return null;
        }
        LogType log = new LogTypeMapper().apply(null, filter.getProcessId());
        HashMap instances = new HashMap();
        List traces = IntStream.range(0, tracesDataSet.getRowCount()).boxed().map(row -> {
            Long pId = DataSetUtils.getColumnLongValue(tracesDataSet, "processInstanceId", row);
            TraceType trace = new TraceTypeMapper().apply(tracesDataSet, (Integer)row);
            instances.put(pId, trace);
            return trace;
        }).collect(Collectors.toList());
        log.getTrace().addAll(traces);
        List<ColumnFilter> eventFilters = this.getEventsColumnFilter(new ArrayList<Long>(instances.keySet()), filter);
        DataSet eventsDataSet = this.dataSetService.findEvents(eventFilters.toArray(new ColumnFilter[eventFilters.size()]));
        LOGGER.debug("Found {} events to export.", (Object)eventsDataSet.getRowCount());
        IntStream.range(0, eventsDataSet.getRowCount()).boxed().forEach(row -> {
            Long pId = DataSetUtils.getColumnLongValue(eventsDataSet, "processInstanceId", row);
            ((TraceType)instances.get(pId)).getEvent().add(new EventTypeMapper().apply(eventsDataSet, (Integer)row));
        });
        String xml = this.marshaller.marshall(log);
        LOGGER.info("XES exported finished in {} seconds", (Object)Duration.between(start, LocalDateTime.now()).getSeconds());
        return xml;
    }

    protected List<ColumnFilter> getEventsColumnFilter(List<Long> pInstances, XESProcessFilter filter) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        filters.add(FilterFactory.in((String)"processInstanceId", pInstances));
        if (!filter.isAllNodeTypes().booleanValue()) {
            filters.add(FilterFactory.in((String)"nodeType", Arrays.asList("HumanTaskNode", "WorkItemNode", "RuleSetNode", "SubProcessNode", "MilestoneNode", "ActionNode")));
        }
        if (filter.getNodeInstanceLogType() != null) {
            filters.add(FilterFactory.equalsTo((String)"type", (Comparable)filter.getNodeInstanceLogType()));
        }
        return filters;
    }
}

