/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.pr.service.ProcessImageService;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.client.UIServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class RemoteProcessImageServiceImpl
extends AbstractKieServerService
implements ProcessImageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteProcessImageServiceImpl.class);

    public String getProcessInstanceDiagram(String serverTemplateId, String containerId, Long processInstanceId, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor) {
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, containerId, UIServicesClient.class);
        try {
            return this.removeActionsFromSVG(uiServicesClient.getProcessInstanceImageCustomColor(containerId, processInstanceId, completedNodeColor, completedNodeBorderColor, activeNodeBorderColor));
        }
        catch (KieServicesHttpException ex) {
            LOGGER.warn("Failed to retrieve process instance image: {}", (Object)ex.getMessage());
            if (ex.getHttpCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public String getProcessDiagram(String serverTemplateId, String containerId, String processId) {
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, containerId, UIServicesClient.class);
        try {
            return this.removeActionsFromSVG(uiServicesClient.getProcessImage(containerId, processId));
        }
        catch (KieServicesHttpException ex) {
            LOGGER.warn("Failed to retrieve process definition image: {}", (Object)ex.getMessage());
            if (ex.getHttpCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    protected String removeActionsFromSVG(String originalHTML) {
        if (originalHTML == null) {
            return null;
        }
        return originalHTML.replaceAll("onclick=\".*?\"|onmouseover=\".*?\"", "");
    }
}

