/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server.util;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jbpm.workbench.pr.backend.server.ProcessInstanceVariableMapper;
import org.jbpm.workbench.pr.backend.server.util.VariableHelper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.kie.server.api.model.instance.VariableInstance;

public class DefaultVariableProcessor
implements VariableHelper.VariableProcessor {
    @Override
    public void process(long processInstanceId, String varName, String varType, List<VariableInstance> variables, String deploymentId, String servetTemplateId, Consumer<ProcessVariableSummary> consumer) {
        Optional<VariableInstance> optional = variables.stream().filter(variableInstance -> variableInstance.getVariableName().equals(varName)).findAny();
        if (optional.isPresent()) {
            VariableInstance variable = optional.get();
            consumer.accept(new ProcessInstanceVariableMapper(deploymentId, servetTemplateId, varType).apply(variable));
            variables.remove(variable);
        } else {
            consumer.accept(new ProcessVariableSummary(varName, "", processInstanceId, "", "", new Date().getTime(), varType, deploymentId, servetTemplateId));
        }
    }

    @Override
    public String getSupportedType() {
        return null;
    }
}

